/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.channel.socket.nio;

import com.datastax.shaded.netty.channel.AbstractChannelSink;
import com.datastax.shaded.netty.channel.Channel;
import com.datastax.shaded.netty.channel.ChannelEvent;
import com.datastax.shaded.netty.channel.ChannelFuture;
import com.datastax.shaded.netty.channel.ChannelPipeline;
import com.datastax.shaded.netty.channel.socket.ChannelRunnableWrapper;
import com.datastax.shaded.netty.channel.socket.nio.AbstractNioChannel;
import com.datastax.shaded.netty.channel.socket.nio.AbstractNioWorker;

public abstract class AbstractNioChannelSink
extends AbstractChannelSink {
    public ChannelFuture execute(ChannelPipeline pipeline, Runnable task) {
        Channel ch = pipeline.getChannel();
        if (ch instanceof AbstractNioChannel) {
            AbstractNioChannel channel = (AbstractNioChannel)ch;
            ChannelRunnableWrapper wrapper = new ChannelRunnableWrapper(pipeline.getChannel(), task);
            channel.worker.executeInIoThread(wrapper);
            return wrapper;
        }
        return super.execute(pipeline, task);
    }

    protected boolean isFireExceptionCaughtLater(ChannelEvent event, Throwable actualCause) {
        Channel channel = event.getChannel();
        boolean fireLater = false;
        if (channel instanceof AbstractNioChannel) {
            fireLater = !AbstractNioWorker.isIoThread((AbstractNioChannel)channel);
        }
        return fireLater;
    }
}

