/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.channel.socket.oio;

import com.datastax.shaded.netty.channel.AbstractChannelSink;
import com.datastax.shaded.netty.channel.Channel;
import com.datastax.shaded.netty.channel.ChannelEvent;
import com.datastax.shaded.netty.channel.ChannelFuture;
import com.datastax.shaded.netty.channel.ChannelPipeline;
import com.datastax.shaded.netty.channel.socket.ChannelRunnableWrapper;
import com.datastax.shaded.netty.channel.socket.Worker;
import com.datastax.shaded.netty.channel.socket.oio.AbstractOioChannel;
import com.datastax.shaded.netty.channel.socket.oio.AbstractOioWorker;

public abstract class AbstractOioChannelSink
extends AbstractChannelSink {
    public ChannelFuture execute(ChannelPipeline pipeline, Runnable task) {
        Channel ch = pipeline.getChannel();
        if (ch instanceof AbstractOioChannel) {
            AbstractOioChannel channel = (AbstractOioChannel)ch;
            Worker worker = channel.worker;
            if (worker != null) {
                ChannelRunnableWrapper wrapper = new ChannelRunnableWrapper(pipeline.getChannel(), task);
                channel.worker.executeInIoThread(wrapper);
                return wrapper;
            }
        }
        return super.execute(pipeline, task);
    }

    protected boolean isFireExceptionCaughtLater(ChannelEvent event, Throwable actualCause) {
        Channel channel = event.getChannel();
        boolean fireLater = false;
        if (channel instanceof AbstractOioChannel) {
            fireLater = !AbstractOioWorker.isIoThread((AbstractOioChannel)channel);
        }
        return fireLater;
    }
}

