/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.execution;

import com.datastax.shaded.netty.channel.ChannelDownstreamHandler;
import com.datastax.shaded.netty.channel.ChannelEvent;
import com.datastax.shaded.netty.channel.ChannelHandler;
import com.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.shaded.netty.channel.ChannelState;
import com.datastax.shaded.netty.channel.ChannelStateEvent;
import com.datastax.shaded.netty.channel.ChannelUpstreamHandler;
import com.datastax.shaded.netty.handler.execution.ChannelDownstreamEventRunnable;
import com.datastax.shaded.netty.handler.execution.ChannelUpstreamEventRunnable;
import com.datastax.shaded.netty.util.ExternalResourceReleasable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

@ChannelHandler.Sharable
public class ExecutionHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler,
ExternalResourceReleasable {
    private final Executor executor;
    private final boolean handleDownstream;
    private final boolean handleUpstream;

    public ExecutionHandler(Executor executor) {
        this(executor, false, true);
    }

    @Deprecated
    public ExecutionHandler(Executor executor, boolean handleDownstream) {
        this(executor, handleDownstream, true);
    }

    public ExecutionHandler(Executor executor, boolean handleDownstream, boolean handleUpstream) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (!handleDownstream && !handleUpstream) {
            throw new IllegalArgumentException("You must handle at least handle one event type");
        }
        this.executor = executor;
        this.handleDownstream = handleDownstream;
        this.handleUpstream = handleUpstream;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void releaseExternalResources() {
        Executor executor = this.getExecutor();
        if (executor instanceof ExecutorService) {
            ((ExecutorService)executor).shutdown();
        }
        if (executor instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)executor)).releaseExternalResources();
        }
    }

    public void handleUpstream(ChannelHandlerContext context, ChannelEvent e) throws Exception {
        if (this.handleUpstream) {
            this.executor.execute(new ChannelUpstreamEventRunnable(context, e, this.executor));
        } else {
            context.sendUpstream(e);
        }
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!this.handleReadSuspend(ctx, e)) {
            if (this.handleDownstream) {
                this.executor.execute(new ChannelDownstreamEventRunnable(ctx, e, this.executor));
            } else {
                ctx.sendDownstream(e);
            }
        }
    }

    protected boolean handleReadSuspend(ChannelHandlerContext ctx, ChannelEvent e) {
        ChannelStateEvent cse;
        if (e instanceof ChannelStateEvent && (cse = (ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS && ((Integer)cse.getValue() & 1) != 0) {
            boolean readSuspended;
            boolean bl = readSuspended = ctx.getAttachment() != null;
            if (readSuspended) {
                e.getFuture().setSuccess();
                return true;
            }
        }
        return false;
    }
}

