/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.DynamicConnectionPool;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.SingleConnectionPool;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

abstract class HostConnectionPool {
    final Host host;
    volatile HostDistance hostDistance;
    protected final SessionManager manager;
    protected final AtomicReference<CloseFuture> closeFuture = new AtomicReference();
    protected final AtomicReference<Phase> phase = new AtomicReference<Phase>(Phase.INITIALIZING);

    static HostConnectionPool newInstance(Host host, HostDistance hostDistance, SessionManager manager, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return new DynamicConnectionPool(host, hostDistance, manager);
            }
            case V3: {
                return new SingleConnectionPool(host, hostDistance, manager);
            }
        }
        throw version.unsupported();
    }

    protected HostConnectionPool(Host host, HostDistance hostDistance, SessionManager manager) {
        assert (hostDistance != HostDistance.IGNORED);
        this.host = host;
        this.hostDistance = hostDistance;
        this.manager = manager;
    }

    abstract ListenableFuture<Void> initAsync(Connection var1);

    abstract Connection borrowConnection(long var1, TimeUnit var3) throws ConnectionException, TimeoutException;

    abstract void returnConnection(Connection var1);

    abstract void ensureCoreConnections();

    abstract void replaceDefunctConnection(Connection var1);

    abstract void cleanupIdleConnections(long var1);

    abstract int opened();

    abstract int trashed();

    abstract int inFlightQueriesCount();

    protected abstract CloseFuture makeCloseFuture();

    public final boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    public final CloseFuture closeAsync() {
        CloseFuture future = this.closeFuture.get();
        if (future != null) {
            return future;
        }
        this.phase.set(Phase.CLOSING);
        future = this.makeCloseFuture();
        return this.closeFuture.compareAndSet(null, future) ? future : this.closeFuture.get();
    }

    static class PoolState {
        volatile String keyspace;

        PoolState() {
        }

        public void setKeyspace(String keyspace) {
            this.keyspace = keyspace;
        }
    }

    protected static enum Phase {
        INITIALIZING,
        READY,
        INIT_FAILED,
        CLOSING;

    }
}

