/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CodecUtils {
    private CodecUtils() {
    }

    public static <T> TypeToken<List<T>> listOf(Class<T> eltType) {
        return new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, eltType);
    }

    public static <T> TypeToken<List<T>> listOf(TypeToken<T> eltType) {
        return new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, eltType);
    }

    public static <T> TypeToken<Set<T>> setOf(Class<T> eltType) {
        return new TypeToken<Set<T>>(){}.where(new TypeParameter<T>(){}, eltType);
    }

    public static <T> TypeToken<Set<T>> setOf(TypeToken<T> eltType) {
        return new TypeToken<Set<T>>(){}.where(new TypeParameter<T>(){}, eltType);
    }

    public static <K, V> TypeToken<Map<K, V>> mapOf(Class<K> keyType, Class<V> valueType) {
        return new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    public static <K, V> TypeToken<Map<K, V>> mapOf(TypeToken<K> keyType, TypeToken<V> valueType) {
        return new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    public static ByteBuffer[] convert(Object[] values, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        ByteBuffer[] serializedValues = new ByteBuffer[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value == null) {
                serializedValues[i] = null;
                continue;
            }
            if (value instanceof Token) {
                serializedValues[i] = ((Token)value).serialize(protocolVersion);
                continue;
            }
            try {
                TypeCodec<Object> codec = codecRegistry.codecFor(value);
                serializedValues[i] = codec.serialize(value, protocolVersion);
                continue;
            }
            catch (Exception e) {
                throw new InvalidTypeException(String.format("Value %d of type %s does not correspond to any CQL3 type", i, value.getClass()), e);
            }
        }
        return serializedValues;
    }

    public static ByteBuffer compose(ByteBuffer ... buffers) {
        if (buffers.length == 1) {
            return buffers[0];
        }
        int totalLength = 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer buffer : buffers) {
            ByteBuffer bb = buffer.duplicate();
            CodecUtils.putShortLength(out, bb.remaining());
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    private static void putShortLength(ByteBuffer bb, int length) {
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }

    public static ByteBuffer pack(List<ByteBuffer> buffers, int elements, ProtocolVersion version) {
        int size = 0;
        for (ByteBuffer bb : buffers) {
            int elemSize = CodecUtils.sizeOfValue(bb, version);
            size += elemSize;
        }
        ByteBuffer result = ByteBuffer.allocate(CodecUtils.sizeOfCollectionSize(version) + size);
        CodecUtils.writeCollectionSize(result, elements, version);
        for (ByteBuffer bb : buffers) {
            CodecUtils.writeCollectionValue(result, bb, version);
        }
        return (ByteBuffer)result.flip();
    }

    public static int readCollectionSize(ByteBuffer input, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return CodecUtils.getUnsignedShort(input);
            }
            case V3: 
            case V4: {
                return input.getInt();
            }
        }
        throw version.unsupported();
    }

    public static ByteBuffer readBytes(ByteBuffer bb, int length) {
        ByteBuffer copy = bb.duplicate();
        copy.limit(copy.position() + length);
        bb.position(bb.position() + length);
        return copy;
    }

    public static ByteBuffer readCollectionValue(ByteBuffer input, ProtocolVersion version) {
        int size;
        switch (version) {
            case V1: 
            case V2: {
                size = CodecUtils.getUnsignedShort(input);
                break;
            }
            case V3: 
            case V4: {
                size = input.getInt();
                break;
            }
            default: {
                throw version.unsupported();
            }
        }
        return size < 0 ? null : CodecUtils.readBytes(input, size);
    }

    private static void writeCollectionSize(ByteBuffer output, int elements, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                if (elements > 65535) {
                    throw new IllegalArgumentException(String.format("Native protocol version %d supports up to 65535 elements in any collection - but collection contains %d elements", version.toInt(), elements));
                }
                output.putShort((short)elements);
                break;
            }
            case V3: 
            case V4: {
                output.putInt(elements);
                break;
            }
            default: {
                throw version.unsupported();
            }
        }
    }

    private static int sizeOfCollectionSize(ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return 2;
            }
            case V3: 
            case V4: {
                return 4;
            }
        }
        throw version.unsupported();
    }

    private static void writeCollectionValue(ByteBuffer output, ByteBuffer value, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                assert (value != null);
                output.putShort((short)value.remaining());
                output.put(value.duplicate());
                break;
            }
            case V3: 
            case V4: {
                if (value == null) {
                    output.putInt(-1);
                    break;
                }
                output.putInt(value.remaining());
                output.put(value.duplicate());
                break;
            }
            default: {
                throw version.unsupported();
            }
        }
    }

    private static int sizeOfValue(ByteBuffer value, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                int elemSize = value.remaining();
                if (elemSize > 65535) {
                    throw new IllegalArgumentException(String.format("Native protocol version %d supports only elements with size up to 65535 bytes - but element size is %d bytes", version.toInt(), elemSize));
                }
                return 2 + elemSize;
            }
            case V3: 
            case V4: {
                return value == null ? 4 : 4 + value.remaining();
            }
        }
        throw version.unsupported();
    }

    private static int getUnsignedShort(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }
}

