/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

abstract class ConvictionPolicy {
    ConvictionPolicy() {
    }

    abstract void signalConnectionCreated();

    abstract void signalConnectionClosed();

    abstract boolean signalConnectionFailure(ConnectionException var1, boolean var2);

    abstract boolean canReconnectNow();

    abstract void reset();

    static class DefaultConvictionPolicy
    extends ConvictionPolicy {
        private final Host host;
        private final ReconnectionPolicy reconnectionPolicy;
        private final AtomicInteger openConnections = new AtomicInteger();
        private volatile long nextReconnectionTime = Long.MIN_VALUE;
        private ReconnectionPolicy.ReconnectionSchedule reconnectionSchedule;

        private DefaultConvictionPolicy(Host host, ReconnectionPolicy reconnectionPolicy) {
            this.host = host;
            this.reconnectionPolicy = reconnectionPolicy;
        }

        @Override
        void signalConnectionCreated() {
            int newCount = this.openConnections.incrementAndGet();
            Host.statesLogger.debug("[{}] new connection created, total = {}", (Object)this.host, (Object)newCount);
            this.resetReconnectionTime();
        }

        @Override
        void signalConnectionClosed() {
            if (this.host.state == Host.State.DOWN) {
                return;
            }
            int remaining = this.openConnections.decrementAndGet();
            assert (remaining >= 0);
            Host.statesLogger.debug("[{}] connection closed, remaining = {}", (Object)this.host, (Object)remaining);
        }

        @Override
        boolean signalConnectionFailure(ConnectionException exception, boolean wasFullyInitialized) {
            int remaining;
            if (this.host.state == Host.State.DOWN) {
                return false;
            }
            this.updateReconnectionTime();
            int n = remaining = wasFullyInitialized ? this.openConnections.decrementAndGet() : this.openConnections.get();
            assert (remaining >= 0);
            Host.statesLogger.debug("[{}] remaining connections = {}", (Object)this.host, (Object)remaining);
            return remaining == 0;
        }

        private synchronized void updateReconnectionTime() {
            long now = System.nanoTime();
            if (this.nextReconnectionTime > now) {
                return;
            }
            if (this.reconnectionSchedule == null) {
                this.reconnectionSchedule = this.reconnectionPolicy.newSchedule();
            }
            long nextDelayMs = this.reconnectionSchedule.nextDelayMs();
            Host.statesLogger.debug("[{}] preventing new connections for the next {} ms", (Object)this.host, (Object)nextDelayMs);
            this.nextReconnectionTime = now + TimeUnit.NANOSECONDS.convert(nextDelayMs, TimeUnit.MILLISECONDS);
        }

        private synchronized void resetReconnectionTime() {
            this.reconnectionSchedule = null;
            this.nextReconnectionTime = Long.MIN_VALUE;
        }

        @Override
        boolean canReconnectNow() {
            return this.nextReconnectionTime == Long.MIN_VALUE || System.nanoTime() >= this.nextReconnectionTime;
        }

        @Override
        synchronized void reset() {
            this.openConnections.set(0);
            this.resetReconnectionTime();
        }

        static class Factory
        implements com.datastax.driver.core.ConvictionPolicy$Factory {
            Factory() {
            }

            @Override
            public ConvictionPolicy create(Host host, ReconnectionPolicy reconnectionPolicy) {
                return new DefaultConvictionPolicy(host, reconnectionPolicy);
            }
        }
    }

    static interface Factory {
        public ConvictionPolicy create(Host var1, ReconnectionPolicy var2);
    }
}

