/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class OverloadedException
extends DriverInternalError
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;

    public OverloadedException(InetSocketAddress address, String message) {
        super(String.format("Queried host (%s) was overloaded: %s", address, message));
        this.address = address;
    }

    private OverloadedException(InetSocketAddress address, String message, OverloadedException cause) {
        super(message, cause);
        this.address = address;
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public OverloadedException copy() {
        return new OverloadedException(this.address, this.getMessage(), this);
    }
}

