/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.InvalidTypeException;

public class UnresolvedUserTypeException
extends InvalidTypeException {
    private final String keyspaceName;
    private final String name;

    public UnresolvedUserTypeException(String keyspaceName, String name) {
        super(String.format("Cannot resolve user type %s.%s", keyspaceName, name));
        this.keyspaceName = keyspaceName;
        this.name = name;
    }

    private UnresolvedUserTypeException(String keyspaceName, String name, Throwable cause) {
        super(String.format("Cannot resolve user type %s.%s", keyspaceName, name), cause);
        this.keyspaceName = keyspaceName;
        this.name = name;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public DriverException copy() {
        return new UnresolvedUserTypeException(this.keyspaceName, this.name, this);
    }
}

