/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;

public class SimpleStatement
extends RegularStatement {
    private final String query;
    private final Object[] values;
    private volatile ByteBuffer routingKey;
    private volatile String keyspace;

    public SimpleStatement(String query) {
        this(query, null);
    }

    public SimpleStatement(String query, Object ... values) {
        if (values != null && values.length > 65535) {
            throw new IllegalArgumentException("Too many values, the maximum allowed is 65535");
        }
        this.query = query;
        this.values = values;
    }

    @Override
    public String getQueryString(CodecRegistry codecRegistry) {
        return this.query;
    }

    @Override
    public ByteBuffer[] getValues(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        if (this.values == null) {
            return null;
        }
        return SimpleStatement.convert(this.values, protocolVersion, codecRegistry);
    }

    public int valuesCount() {
        return this.values == null ? 0 : this.values.length;
    }

    @Override
    public boolean hasValues(CodecRegistry codecRegistry) {
        return this.values != null && this.values.length > 0;
    }

    public Object getObject(int i) {
        if (this.values == null) {
            throw new IllegalStateException("This statement does not have values");
        }
        if (i < 0 || i >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.values[i];
    }

    @Override
    public ByteBuffer getRoutingKey(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        return this.routingKey;
    }

    public SimpleStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public SimpleStatement setKeyspace(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public SimpleStatement setRoutingKey(ByteBuffer ... routingKeyComponents) {
        this.routingKey = SimpleStatement.compose(routingKeyComponents);
        return this;
    }

    public static ByteBuffer[] convert(Object[] values, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        ByteBuffer[] serializedValues = new ByteBuffer[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value == null) {
                serializedValues[i] = null;
                continue;
            }
            if (value instanceof Token) {
                serializedValues[i] = ((Token)value).serialize(protocolVersion);
                continue;
            }
            try {
                TypeCodec<Object> codec = codecRegistry.codecFor(value);
                serializedValues[i] = codec.serialize(value, protocolVersion);
                continue;
            }
            catch (Exception e) {
                throw new InvalidTypeException(String.format("Value %d of type %s does not correspond to any CQL3 type", i, value.getClass()), e);
            }
        }
        return serializedValues;
    }

    static ByteBuffer compose(ByteBuffer ... buffers) {
        if (buffers.length == 1) {
            return buffers[0];
        }
        int totalLength = 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer buffer : buffers) {
            ByteBuffer bb = buffer.duplicate();
            SimpleStatement.putShortLength(out, bb.remaining());
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    static void putShortLength(ByteBuffer bb, int length) {
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }
}

