/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;

public interface RetryPolicy {
    public RetryDecision onReadTimeout(Statement var1, ConsistencyLevel var2, int var3, int var4, boolean var5, int var6);

    public RetryDecision onWriteTimeout(Statement var1, ConsistencyLevel var2, WriteType var3, int var4, int var5, int var6);

    public RetryDecision onUnavailable(Statement var1, ConsistencyLevel var2, int var3, int var4, int var5);

    public RetryDecision onRequestError(Statement var1, ConsistencyLevel var2, DriverException var3, int var4);

    public void init(Cluster var1);

    public void close();

    public static class RetryDecision {
        private final Type type;
        private final ConsistencyLevel retryCL;
        private final boolean retryCurrent;

        private RetryDecision(Type type, ConsistencyLevel retryCL, boolean retryCurrent) {
            this.type = type;
            this.retryCL = retryCL;
            this.retryCurrent = retryCurrent;
        }

        public Type getType() {
            return this.type;
        }

        public ConsistencyLevel getRetryConsistencyLevel() {
            return this.retryCL;
        }

        public boolean isRetryCurrent() {
            return this.retryCurrent;
        }

        public static RetryDecision rethrow() {
            return new RetryDecision(Type.RETHROW, null, true);
        }

        public static RetryDecision retry(ConsistencyLevel consistency) {
            return new RetryDecision(Type.RETRY, consistency, true);
        }

        public static RetryDecision ignore() {
            return new RetryDecision(Type.IGNORE, null, true);
        }

        public static RetryDecision tryNextHost(ConsistencyLevel retryCL) {
            return new RetryDecision(Type.RETRY, retryCL, false);
        }

        public String toString() {
            switch (this.type) {
                case RETRY: {
                    return "Retry at " + (Object)((Object)this.retryCL) + " on " + (this.retryCurrent ? "same " : "next ") + "host.";
                }
                case RETHROW: {
                    return "Rethrow";
                }
                case IGNORE: {
                    return "Ignore";
                }
            }
            throw new AssertionError();
        }

        public static enum Type {
            RETRY,
            RETHROW,
            IGNORE;

        }
    }
}

