/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.RetryPolicy;
import java.nio.ByteBuffer;
import java.util.Map;

public abstract class StatementWrapper
extends Statement {
    private final Statement wrapped;

    protected StatementWrapper(Statement wrapped) {
        this.wrapped = wrapped;
    }

    Statement getWrappedStatement() {
        return this.wrapped instanceof StatementWrapper ? ((StatementWrapper)this.wrapped).getWrappedStatement() : this.wrapped;
    }

    @Override
    public Statement setConsistencyLevel(ConsistencyLevel consistency) {
        this.wrapped.setConsistencyLevel(consistency);
        return this;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.wrapped.getConsistencyLevel();
    }

    @Override
    public Statement setSerialConsistencyLevel(ConsistencyLevel serialConsistency) {
        this.wrapped.setSerialConsistencyLevel(serialConsistency);
        return this;
    }

    @Override
    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.wrapped.getSerialConsistencyLevel();
    }

    @Override
    public Statement enableTracing() {
        this.wrapped.enableTracing();
        return this;
    }

    @Override
    public Statement disableTracing() {
        this.wrapped.disableTracing();
        return this;
    }

    @Override
    public boolean isTracing() {
        return this.wrapped.isTracing();
    }

    @Override
    public ByteBuffer getRoutingKey(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        return this.wrapped.getRoutingKey(protocolVersion, codecRegistry);
    }

    @Override
    public String getKeyspace() {
        return this.wrapped.getKeyspace();
    }

    @Override
    public Statement setRetryPolicy(RetryPolicy policy) {
        this.wrapped.setRetryPolicy(policy);
        return this;
    }

    @Override
    public RetryPolicy getRetryPolicy() {
        return this.wrapped.getRetryPolicy();
    }

    @Override
    public Statement setFetchSize(int fetchSize) {
        this.wrapped.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public int getFetchSize() {
        return this.wrapped.getFetchSize();
    }

    @Override
    public Statement setDefaultTimestamp(long defaultTimestamp) {
        this.wrapped.setDefaultTimestamp(defaultTimestamp);
        return this;
    }

    @Override
    public long getDefaultTimestamp() {
        return this.wrapped.getDefaultTimestamp();
    }

    @Override
    public Statement setReadTimeoutMillis(int readTimeoutMillis) {
        this.wrapped.setReadTimeoutMillis(readTimeoutMillis);
        return this;
    }

    @Override
    public int getReadTimeoutMillis() {
        return this.wrapped.getReadTimeoutMillis();
    }

    @Override
    public Statement setPagingState(PagingState pagingState, CodecRegistry codecRegistry) {
        this.wrapped.setPagingState(pagingState, codecRegistry);
        return this;
    }

    @Override
    public Statement setPagingState(PagingState pagingState) {
        this.wrapped.setPagingState(pagingState);
        return this;
    }

    @Override
    public Statement setPagingStateUnsafe(byte[] pagingState) {
        this.wrapped.setPagingStateUnsafe(pagingState);
        return this;
    }

    @Override
    public ByteBuffer getPagingState() {
        return this.wrapped.getPagingState();
    }

    @Override
    public Statement setIdempotent(boolean idempotent) {
        this.wrapped.setIdempotent(idempotent);
        return this;
    }

    @Override
    public Boolean isIdempotent() {
        return this.wrapped.isIdempotent();
    }

    @Override
    public boolean isIdempotentWithDefault(QueryOptions queryOptions) {
        return this.wrapped.isIdempotentWithDefault(queryOptions);
    }

    @Override
    public Map<String, ByteBuffer> getOutgoingPayload() {
        return this.wrapped.getOutgoingPayload();
    }

    @Override
    public Statement setOutgoingPayload(Map<String, ByteBuffer> payload) {
        this.wrapped.setOutgoingPayload(payload);
        return this;
    }

    @Override
    public int requestSizeInBytes(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        return this.wrapped.requestSizeInBytes(protocolVersion, codecRegistry);
    }

    @Override
    public Host getHost() {
        return this.wrapped.getHost();
    }

    @Override
    public Statement setHost(Host host) {
        this.wrapped.setHost(host);
        return this;
    }
}

