/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.FrameCompressor;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SystemProperties;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.FrameTooLongException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.TooLongFrameException;
import java.util.EnumSet;
import java.util.List;

class Frame {
    final Header header;
    final ByteBuf body;

    private Frame(Header header, ByteBuf body) {
        this.header = header;
        this.body = body;
    }

    private static Frame create(ByteBuf fullFrame) {
        assert (fullFrame.readableBytes() >= 1) : String.format("Frame too short (%d bytes)", fullFrame.readableBytes());
        byte versionBytes = fullFrame.readByte();
        ProtocolVersion version = ProtocolVersion.fromInt(versionBytes & 0x7F);
        int hdrLen = Header.lengthFor(version);
        assert (fullFrame.readableBytes() >= hdrLen - 1) : String.format("Frame too short (%d bytes)", fullFrame.readableBytes());
        byte flags = fullFrame.readByte();
        int streamId = Frame.readStreamid(fullFrame, version);
        byte opcode = fullFrame.readByte();
        int length = fullFrame.readInt();
        assert (length == fullFrame.readableBytes());
        Header header = new Header(version, flags, streamId, (int)opcode);
        return new Frame(header, fullFrame);
    }

    private static int readStreamid(ByteBuf fullFrame, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return fullFrame.readByte();
            }
            case V3: 
            case V4: 
            case V5: {
                return fullFrame.readShort();
            }
        }
        throw version.unsupported();
    }

    static Frame create(ProtocolVersion version, int opcode, int streamId, EnumSet<Header.Flag> flags, ByteBuf body) {
        Header header = new Header(version, flags, streamId, opcode);
        return new Frame(header, body);
    }

    Frame with(ByteBuf newBody) {
        return new Frame(this.header, newBody);
    }

    static class Compressor
    extends MessageToMessageEncoder<Frame> {
        private final FrameCompressor compressor;

        Compressor(FrameCompressor compressor) {
            assert (compressor != null);
            this.compressor = compressor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void encode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            if (frame.header.opcode == Message.Request.Type.STARTUP.opcode) {
                out.add(frame);
            } else {
                frame.header.flags.add(Header.Flag.COMPRESSED);
                ByteBuf uncompressedBody = frame.body;
                try {
                    out.add(this.compressor.compress(frame));
                }
                finally {
                    uncompressedBody.release();
                }
            }
        }
    }

    static class Decompressor
    extends MessageToMessageDecoder<Frame> {
        private final FrameCompressor compressor;

        Decompressor(FrameCompressor compressor) {
            assert (compressor != null);
            this.compressor = compressor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void decode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            if (frame.header.flags.contains((Object)Header.Flag.COMPRESSED)) {
                ByteBuf compressedBody = frame.body;
                try {
                    out.add(this.compressor.decompress(frame));
                }
                finally {
                    compressedBody.release();
                }
            } else {
                out.add(frame);
            }
        }
    }

    @ChannelHandler.Sharable
    static class Encoder
    extends MessageToMessageEncoder<Frame> {
        Encoder() {
        }

        protected void encode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            ProtocolVersion protocolVersion = frame.header.version;
            ByteBuf header = ctx.alloc().ioBuffer(Header.lengthFor(protocolVersion));
            header.writeByte(frame.header.version.toInt());
            header.writeByte(Header.Flag.serialize(frame.header.flags));
            this.writeStreamId(frame.header.streamId, header, protocolVersion);
            header.writeByte(frame.header.opcode);
            header.writeInt(frame.body.readableBytes());
            out.add(header);
            out.add(frame.body);
        }

        private void writeStreamId(int streamId, ByteBuf header, ProtocolVersion protocolVersion) {
            switch (protocolVersion) {
                case V1: 
                case V2: {
                    header.writeByte(streamId);
                    break;
                }
                case V3: 
                case V4: 
                case V5: {
                    header.writeShort(streamId);
                    break;
                }
                default: {
                    throw protocolVersion.unsupported();
                }
            }
        }
    }

    static final class Decoder
    extends ByteToMessageDecoder {
        private DecoderForStreamIdSize decoder;

        Decoder() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
            Object frame;
            if (buffer.readableBytes() < 1) {
                return;
            }
            if (this.decoder == null) {
                int version = buffer.getByte(buffer.readerIndex());
                this.decoder = new DecoderForStreamIdSize(version, (version &= 0x7F) >= 3 ? 2 : 1);
            }
            if ((frame = this.decoder.decode(ctx, buffer)) != null) {
                out.add(frame);
            }
        }

        static class DecoderForStreamIdSize
        extends LengthFieldBasedFrameDecoder {
            private static final int MAX_FRAME_LENGTH = SystemProperties.getInt("com.datastax.driver.NATIVE_TRANSPORT_MAX_FRAME_SIZE_IN_MB", 256) * 1024 * 1024;
            private final int protocolVersion;

            DecoderForStreamIdSize(int protocolVersion, int streamIdSize) {
                super(MAX_FRAME_LENGTH, 3 + streamIdSize, 4, 0, 0, true);
                this.protocolVersion = protocolVersion;
            }

            protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
                int curIndex = buffer.readerIndex();
                try {
                    ByteBuf frame = (ByteBuf)super.decode(ctx, buffer);
                    if (frame == null) {
                        return null;
                    }
                    Frame theFrame = Frame.create(frame);
                    Message.Response.Type.fromOpcode(theFrame.header.opcode);
                    return theFrame;
                }
                catch (CorruptedFrameException e) {
                    throw new DriverInternalError(e);
                }
                catch (TooLongFrameException e) {
                    short streamId = this.protocolVersion > 2 ? buffer.getShort(curIndex + 2) : (short)buffer.getByte(curIndex + 2);
                    throw new FrameTooLongException(streamId);
                }
            }
        }
    }

    static class Header {
        final ProtocolVersion version;
        final EnumSet<Flag> flags;
        final int streamId;
        final int opcode;

        private Header(ProtocolVersion version, int flags, int streamId, int opcode) {
            this(version, Flag.deserialize(flags), streamId, opcode);
        }

        private Header(ProtocolVersion version, EnumSet<Flag> flags, int streamId, int opcode) {
            this.version = version;
            this.flags = flags;
            this.streamId = streamId;
            this.opcode = opcode;
        }

        static int lengthFor(ProtocolVersion version) {
            switch (version) {
                case V1: 
                case V2: {
                    return 8;
                }
                case V3: 
                case V4: 
                case V5: {
                    return 9;
                }
            }
            throw version.unsupported();
        }

        static enum Flag {
            COMPRESSED,
            TRACING,
            CUSTOM_PAYLOAD,
            WARNING,
            USE_BETA;


            static EnumSet<Flag> deserialize(int flags) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                Flag[] values = Flag.values();
                for (int n = 0; n < 8; ++n) {
                    if ((flags & 1 << n) == 0) continue;
                    set.add(values[n]);
                }
                return set;
            }

            static int serialize(EnumSet<Flag> flags) {
                int i = 0;
                for (Flag flag : flags) {
                    i |= 1 << flag.ordinal();
                }
                return i;
            }
        }
    }
}

