/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.auth;

import com.datastax.driver.auth.PrivilegedSaslClient;
import com.datastax.driver.core.Authenticator;
import java.net.InetAddress;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(KerberosAuthenticator.class);
    public static final String JAAS_CONFIG_ENTRY = "DseClient";
    public static final String[] SUPPORTED_MECHANISMS = new String[]{"GSSAPI"};
    public static final String SASL_PROTOCOL_NAME = "dse";
    public static final String SASL_PROTOCOL_NAME_PROPERTY = "dse.sasl.protocol";
    private final PrivilegedSaslClient saslClient;

    public KerberosAuthenticator(InetAddress host) {
        this.saslClient = new PrivilegedSaslClient(this.loginSubject(), SUPPORTED_MECHANISMS, null, System.getProperty(SASL_PROTOCOL_NAME_PROPERTY, SASL_PROTOCOL_NAME), host.getCanonicalHostName(), PrivilegedSaslClient.DEFAULT_PROPERTIES, null);
    }

    private Subject loginSubject() {
        Subject subject = new Subject();
        try {
            LoginContext login = new LoginContext(JAAS_CONFIG_ENTRY, subject);
            login.login();
            return subject;
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] initialResponse() {
        return this.saslClient.getInitialResponse();
    }

    public byte[] evaluateChallenge(byte[] challenge) {
        byte[] response = this.saslClient.evaluateChallenge(challenge);
        if (response == null) {
            logger.trace("Response to server is null: authentication should now be complete.");
            if (!this.saslClient.isComplete()) {
                String error = "Client generated a null sasl response, but authentication is not complete.";
                logger.error(error);
                throw new RuntimeException(error);
            }
        }
        return response;
    }

    public void onAuthenticationSuccess(byte[] token) {
    }
}

