/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.stress;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.stress.Consumer;
import com.datastax.driver.stress.QueryGenerator;
import com.datastax.driver.stress.Reporter;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.yammer.metrics.core.TimerContext;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AsynchronousConsumer
implements Consumer {
    private static final ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final Session session;
    private final Iterator<QueryGenerator.Request> requests;
    private final Reporter reporter;

    public AsynchronousConsumer(Session session, Iterator<QueryGenerator.Request> requests, Reporter reporter) {
        this.session = session;
        this.requests = requests;
        this.reporter = reporter;
    }

    @Override
    public void start() {
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                AsynchronousConsumer.this.request();
            }
        });
    }

    private void request() {
        if (!this.requests.hasNext()) {
            this.shutdown();
            return;
        }
        this.handle(this.requests.next());
    }

    @Override
    public void join() {
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.shutdownLatch);
    }

    protected void handle(QueryGenerator.Request request) {
        final TimerContext timerContext = this.reporter.latencies.time();
        ResultSetFuture resultSetFuture = request.executeAsync(this.session);
        Futures.addCallback((ListenableFuture)resultSetFuture, (FutureCallback)new FutureCallback<ResultSet>(){

            public void onSuccess(ResultSet result) {
                timerContext.stop();
                ((AsynchronousConsumer)AsynchronousConsumer.this).reporter.requests.mark();
                AsynchronousConsumer.this.request();
            }

            public void onFailure(Throwable t) {
                System.err.println("Error during request: " + t);
                timerContext.stop();
                ((AsynchronousConsumer)AsynchronousConsumer.this).reporter.requests.mark();
                AsynchronousConsumer.this.request();
            }
        }, (Executor)executorService);
    }

    protected void shutdown() {
        this.shutdownLatch.countDown();
    }
}

