/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.stress;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.stress.Consumer;
import com.datastax.driver.stress.QueryGenerator;
import com.datastax.driver.stress.Reporter;
import com.google.common.util.concurrent.Uninterruptibles;
import com.yammer.metrics.core.TimerContext;
import java.util.Iterator;

public class BlockingConsumer
implements Consumer {
    private final Runner runner = new Runner();
    private final Session session;
    private final Iterator<QueryGenerator.Request> requests;
    private final Reporter reporter;

    public BlockingConsumer(Session session, Iterator<QueryGenerator.Request> requests, Reporter reporter) {
        this.session = session;
        this.requests = requests;
        this.reporter = reporter;
        this.runner.setDaemon(true);
    }

    @Override
    public void start() {
        this.runner.start();
    }

    @Override
    public void join() {
        Uninterruptibles.joinUninterruptibly((Thread)this.runner);
    }

    private class Runner
    extends Thread {
        public Runner() {
            super("Consumer Threads");
        }

        @Override
        public void run() {
            try {
                while (BlockingConsumer.this.requests.hasNext()) {
                    this.handle((QueryGenerator.Request)BlockingConsumer.this.requests.next());
                }
            }
            catch (DriverException e) {
                System.err.println("Error during query: " + e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handle(QueryGenerator.Request request) {
            TimerContext context = ((BlockingConsumer)BlockingConsumer.this).reporter.latencies.time();
            try {
                request.execute(BlockingConsumer.this.session);
            }
            finally {
                context.stop();
                ((BlockingConsumer)BlockingConsumer.this).reporter.requests.mark();
            }
        }
    }
}

