/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.stress;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.stress.QueryGenerator;
import java.nio.ByteBuffer;
import java.util.Random;
import joptsimple.OptionSet;
import org.apache.cassandra.utils.ByteBufferUtil;

public class Generators {
    private static ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    public static final QueryGenerator.Builder CASSANDRA_INSERTER = new QueryGenerator.Builder(){

        @Override
        public void createSchema(OptionSet options, Session session) {
            Generators.createCassandraStressTables(session, options);
        }

        @Override
        public QueryGenerator create(int id, int iterations, OptionSet options, Session session) {
            final int valueSize = (Integer)options.valueOf("value-size");
            final int columnsPerRow = (Integer)options.valueOf("columns-per-row");
            final long prefix = (long)id << 32;
            return new QueryGenerator(iterations){
                private int i;

                @Override
                public boolean hasNext() {
                    return this.iterations == -1 || this.i < this.iterations;
                }

                @Override
                public QueryGenerator.Request next() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("UPDATE Standard1 SET ");
                    for (int i = 0; i < columnsPerRow; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append("C").append(i).append("='").append(ByteBufferUtil.bytesToHex((ByteBuffer)Generators.makeValue(valueSize))).append("'");
                    }
                    sb.append(" WHERE key = ").append(prefix | (long)this.i);
                    ++this.i;
                    return new QueryGenerator.Request.SimpleQuery((Query)new SimpleStatement(sb.toString()));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };
    public static final QueryGenerator.Builder CASSANDRA_PREPARED_INSERTER = new QueryGenerator.Builder(){

        @Override
        public void createSchema(OptionSet options, Session session) {
            Generators.createCassandraStressTables(session, options);
        }

        @Override
        public QueryGenerator create(int id, int iterations, OptionSet options, Session session) {
            final int columnsPerRow = (Integer)options.valueOf("columns-per-row");
            final int valueSize = (Integer)options.valueOf("value-size");
            final long prefix = (long)id << 32;
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE Standard1 SET ");
            for (int i = 0; i < columnsPerRow; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("C").append(i).append("=?");
            }
            sb.append(" WHERE key = ?");
            final PreparedStatement stmt = session.prepare(sb.toString());
            return new QueryGenerator(iterations){
                private int i;

                @Override
                public boolean hasNext() {
                    return this.iterations == -1 || this.i < this.iterations;
                }

                @Override
                public QueryGenerator.Request next() {
                    BoundStatement b = stmt.bind(new Object[0]);
                    b.setLong("key", prefix | (long)this.i);
                    for (int i = 0; i < columnsPerRow; ++i) {
                        b.setBytes("c" + i, Generators.makeValue(valueSize));
                    }
                    ++this.i;
                    return new QueryGenerator.Request.PreparedQuery(b);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };

    private static void createCassandraStressTables(Session session, OptionSet options) {
        try {
            session.execute("CREATE KEYSPACE stress WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : 1 }");
        }
        catch (AlreadyExistsException e) {
            // empty catch block
        }
        session.execute("USE stress");
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE Standard1 (key bigint PRIMARY KEY");
        for (int i = 0; i < (Integer)options.valueOf("columns-per-row"); ++i) {
            sb.append(", C").append(i).append(" blob");
        }
        sb.append(")");
        try {
            session.execute(sb.toString());
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    private static ByteBuffer makeValue(int valueSize) {
        byte[] value = new byte[valueSize];
        random.get().nextBytes(value);
        return ByteBuffer.wrap(value);
    }
}

