/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.stress;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import java.util.Iterator;
import joptsimple.OptionSet;

public abstract class QueryGenerator
implements Iterator<Request> {
    protected final int iterations;

    protected QueryGenerator(int iterations) {
        this.iterations = iterations;
    }

    public static interface Request {
        public ResultSet execute(Session var1);

        public ResultSetFuture executeAsync(Session var1);

        public static class PreparedQuery
        implements Request {
            private final BoundStatement query;

            public PreparedQuery(BoundStatement query) {
                this.query = query;
            }

            @Override
            public ResultSet execute(Session session) {
                return session.execute((Query)this.query);
            }

            @Override
            public ResultSetFuture executeAsync(Session session) {
                return session.executeAsync((Query)this.query);
            }
        }

        public static class SimpleQuery
        implements Request {
            private final Query query;

            public SimpleQuery(Query query) {
                this.query = query;
            }

            @Override
            public ResultSet execute(Session session) {
                return session.execute(this.query);
            }

            @Override
            public ResultSetFuture executeAsync(Session session) {
                return session.executeAsync(this.query);
            }
        }
    }

    public static interface Builder {
        public void createSchema(OptionSet var1, Session var2);

        public QueryGenerator create(int var1, int var2, OptionSet var3, Session var4);
    }
}

