/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.stress;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.stress.AsynchronousConsumer;
import com.datastax.driver.stress.BlockingConsumer;
import com.datastax.driver.stress.Consumer;
import com.datastax.driver.stress.Generators;
import com.datastax.driver.stress.QueryGenerator;
import com.datastax.driver.stress.Reporter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class Stress {
    private static final Map<String, QueryGenerator.Builder> generators = new HashMap<String, QueryGenerator.Builder>();
    private static final OptionParser parser = new OptionParser(){
        {
            this.accepts("h", "Show this help message");
            this.accepts("n", "Number of requests to perform (default: unlimited)").withRequiredArg().ofType(Integer.class);
            this.accepts("t", "Level of concurrency to use").withRequiredArg().ofType(Integer.class).defaultsTo((Object)50, (Object[])new Integer[0]);
            this.accepts("async", "Make asynchronous requests instead of blocking ones");
            this.accepts("csv", "Save metrics into csv instead of displaying on stdout");
            this.accepts("columns-per-row", "Number of columns per CQL3 row").withRequiredArg().ofType(Integer.class).defaultsTo((Object)5, (Object[])new Integer[0]);
            this.accepts("value-size", "The size in bytes for column values").withRequiredArg().ofType(Integer.class).defaultsTo((Object)34, (Object[])new Integer[0]);
            this.accepts("ip", "The hosts ip to connect to").withRequiredArg().ofType(String.class).defaultsTo((Object)"127.0.0.1", (Object[])new String[0]);
        }
    };

    public static void register(String name, QueryGenerator.Builder generator) {
        if (generators.containsKey(name)) {
            throw new IllegalStateException("There is already a generator registered with the name " + name);
        }
        generators.put(name, generator);
    }

    private static void printHelp(OptionParser parser, Collection<String> generators) {
        System.out.println("Usage: stress <generator> [<option>]*\n");
        System.out.println("Where <generator> can be one of " + generators);
        System.out.println();
        try {
            parser.printHelpOn((OutputStream)System.out);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static OptionSet parseOptions(String[] args) {
        try {
            OptionSet options = parser.parse(args);
            if (options.has("h")) {
                Stress.printHelp(parser, generators.keySet());
                System.exit(0);
            }
            return options;
        }
        catch (Exception e) {
            System.err.println("Error parsing options: " + e.getMessage());
            Stress.printHelp(parser, generators.keySet());
            System.exit(1);
            throw new AssertionError();
        }
    }

    private static QueryGenerator.Builder getGenerator(OptionSet options) {
        String action;
        Stress.register("insert", Generators.CASSANDRA_INSERTER);
        Stress.register("insert_prepared", Generators.CASSANDRA_PREPARED_INSERTER);
        List args = options.nonOptionArguments();
        if (args.isEmpty()) {
            System.err.println("Missing generator, you need to provide a generator.");
            Stress.printHelp(parser, generators.keySet());
            System.exit(1);
        }
        if (args.size() > 1) {
            System.err.println("Too many generators provided. Got " + args + " but only one generator supported.");
            Stress.printHelp(parser, generators.keySet());
            System.exit(1);
        }
        if (!generators.containsKey(action = (String)args.get(0))) {
            System.err.println(String.format("Unknown generator '%s'", action));
            Stress.printHelp(parser, generators.keySet());
            System.exit(1);
        }
        return generators.get(action);
    }

    public static void main(String[] args) throws Exception {
        OptionSet options = Stress.parseOptions(args);
        QueryGenerator.Builder genBuilder = Stress.getGenerator(options);
        int requests = options.has("n") ? (Integer)options.valueOf("n") : -1;
        int concurrency = (Integer)options.valueOf("t");
        boolean async = options.has("async");
        boolean useCsv = options.has("csv");
        System.out.println("Initializing stress test...");
        System.out.println("request count: " + (requests == -1 ? "unlimited" : Integer.valueOf(requests)));
        System.out.println("concurrency: " + concurrency);
        System.out.println("mode: " + (async ? "asynchronous" : "blocking"));
        try {
            Cluster cluster = new Cluster.Builder().addContactPoints(new String[]{String.valueOf(options.valueOf("ip"))}).build();
            int maxRequestsPerConnection = 128;
            int maxConnections = concurrency / 128 + 1;
            PoolingOptions pools = cluster.getConfiguration().getPoolingOptions();
            pools.setMaxSimultaneousRequestsPerConnectionThreshold(HostDistance.LOCAL, concurrency);
            pools.setCoreConnectionsPerHost(HostDistance.LOCAL, maxConnections);
            pools.setMaxConnectionsPerHost(HostDistance.LOCAL, maxConnections);
            pools.setCoreConnectionsPerHost(HostDistance.REMOTE, maxConnections);
            pools.setMaxConnectionsPerHost(HostDistance.REMOTE, maxConnections);
            Session session = cluster.connect();
            Metadata metadata = cluster.getMetadata();
            System.out.println(String.format("Connected to cluster '%s' on %s.", metadata.getClusterName(), metadata.getAllHosts()));
            System.out.println("Creating schema...");
            genBuilder.createSchema(options, session);
            Reporter reporter = new Reporter(useCsv);
            Consumer[] consumers = new Consumer[concurrency];
            for (int i = 0; i < concurrency; ++i) {
                int iterations = requests == -1 ? -1 : requests / concurrency;
                QueryGenerator generator = genBuilder.create(i, iterations, options, session);
                consumers[i] = async ? new AsynchronousConsumer(session, generator, reporter) : new BlockingConsumer(session, generator, reporter);
            }
            System.out.println("Starting to stress test...");
            for (Consumer consumer : consumers) {
                consumer.start();
            }
            for (Consumer consumer : consumers) {
                consumer.join();
            }
            System.out.println("Stress test successful.");
            System.exit(0);
        }
        catch (NoHostAvailableException e) {
            System.err.println("No alive hosts to use: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

