/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.jdk8;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeCodec
extends TypeCodec<LocalTime> {
    public static final LocalTimeCodec instance = new LocalTimeCodec();
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");

    private LocalTimeCodec() {
        super(DataType.time(), LocalTime.class);
    }

    public ByteBuffer serialize(LocalTime value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (value == null) {
            return null;
        }
        return LocalTimeCodec.bigint().serializeNoBoxing(value.toNanoOfDay(), protocolVersion);
    }

    public LocalTime deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        long nanosOfDay = LocalTimeCodec.bigint().deserializeNoBoxing(bytes, protocolVersion);
        return LocalTime.ofNanoOfDay(nanosOfDay);
    }

    public String format(LocalTime value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote((String)FORMATTER.format(value));
    }

    public LocalTime parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!ParseUtils.isQuoted((String)value)) {
            throw new InvalidTypeException("time values must be enclosed by single quotes");
        }
        if (ParseUtils.isLongLiteral((String)(value = value.substring(1, value.length() - 1)))) {
            long nanosOfDay;
            try {
                nanosOfDay = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse time value from \"%s\"", value), (Throwable)e);
            }
            return LocalTime.ofNanoOfDay(nanosOfDay);
        }
        try {
            return LocalTime.parse(value);
        }
        catch (RuntimeException e) {
            throw new InvalidTypeException(String.format("Cannot parse time value from \"%s\"", value), (Throwable)e);
        }
    }
}

