/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.handler;

import com.day.cq.dam.commons.handler.Filter;
import com.day.cq.dam.commons.handler.FilterStateListener;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractFilter
implements Filter {
    protected Filter nextFilter;
    protected int streamPos;
    protected FilterStateListener listener;
    protected OutputStream out;
    protected boolean autoReset;

    protected AbstractFilter(AbstractFilter nextFilter) {
        this.nextFilter = nextFilter;
    }

    protected AbstractFilter() {
        this(null);
    }

    protected void doReset() {
        this.out = null;
    }

    protected abstract void doFilter(byte[] var1, int var2, int var3) throws IOException;

    protected void put(int b) throws IOException {
        this.put(new byte[]{(byte)b});
    }

    protected void put(byte[] buf) throws IOException {
        if (this.nextFilter != null) {
            this.nextFilter.filter(buf, 0, buf.length);
        }
        if (this.out != null) {
            this.out.write(buf, 0, buf.length);
        }
    }

    protected void put(byte[] buf, int off, int len) throws IOException {
        if (this.nextFilter != null) {
            this.nextFilter.filter(buf, 0, buf.length);
        }
        if (this.out != null) {
            this.out.write(buf, off, len);
        }
    }

    public void setFilterStateListener(FilterStateListener listener) {
        this.listener = listener;
    }

    protected void notifyStarted() {
        if (this.nextFilter != null) {
            this.nextFilter.reset();
        }
        if (this.listener != null) {
            this.out = this.listener.started(this);
        }
    }

    protected void notifyEnded() {
        if (this.listener != null) {
            this.listener.ended(this, this.out);
        }
        if (this.autoReset) {
            this.reset();
        }
    }

    public final void filter(byte[] buf, int off, int len) throws IOException {
        this.doFilter(buf, off, len);
        this.streamPos += len;
    }

    public final void reset() {
        if (this.nextFilter != null) {
            this.nextFilter.reset();
        }
        this.doReset();
    }

    public void setAutoReset(boolean autoReset) {
        this.autoReset = autoReset;
    }

    public boolean isValid() {
        return true;
    }
}

