/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.thumbnail.ThumbnailConfig;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.SameNodeJoinCondition;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DamUtil {
    private static final Logger log = LoggerFactory.getLogger(DamUtil.class);

    public static String assetToBinaryPath(String path) {
        String binaryPath = null;
        if (StringUtils.startsWith((String)path, (String)"/content/dam")) {
            binaryPath = StringUtils.replaceOnce((String)path, (String)"/content/dam", (String)"/var/dam");
        }
        return binaryPath;
    }

    public static String binaryToAssetPath(String path) {
        String assetPath = null;
        if (StringUtils.startsWith((String)path, (String)"/var/dam")) {
            assetPath = StringUtils.replaceOnce((String)path, (String)"/var/dam", (String)"/content/dam");
        }
        return assetPath;
    }

    public static boolean isThumbnail(Node file) {
        try {
            return file.isNodeType("nt:file") && file.getName().startsWith("cq5dam.thumbnail");
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    public static String getThumbnailName(int width, int height) {
        return DamUtil.getThumbnailName(width, height, null);
    }

    public static String getThumbnailName(ThumbnailConfig config) {
        String[] stringArray;
        if (config.doCenter()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "margin";
        } else {
            stringArray = null;
        }
        String[] selectors = stringArray;
        return DamUtil.getThumbnailName(config.getWidth(), config.getHeight(), selectors);
    }

    public static String getThumbnailName(int width, int height, String[] selectors) {
        String selectorString = StringUtils.join((Object[])(selectors = null != selectors ? selectors : new String[]{}), (char)'.');
        if (!"".equals(selectorString)) {
            selectorString = "." + selectorString;
        }
        return "cq5dam.thumbnail." + String.valueOf(width) + "." + String.valueOf(height) + selectorString + ".png";
    }

    public static boolean isRendition(Resource resource) {
        if (null == resource) {
            return false;
        }
        Resource parent = ResourceUtil.getParent((Resource)resource);
        if (null == parent) {
            return false;
        }
        Resource content = ResourceUtil.getParent((Resource)parent);
        if (null == content) {
            return false;
        }
        Resource asset = ResourceUtil.getParent((Resource)content);
        if (null == asset) {
            return false;
        }
        return "renditions".equals(ResourceUtil.getName((Resource)parent)) && DamUtil.isAsset(asset);
    }

    public static boolean isAsset(Resource resource) {
        return null != resource && "dam:Asset".equals(resource.getResourceType());
    }

    public static boolean isSubAsset(Resource resource) {
        return DamUtil.isAsset(resource) && "subassets".equals(ResourceUtil.getName((Resource)ResourceUtil.getParent((Resource)resource)));
    }

    public static Asset resolveToAsset(Resource resource) {
        if (null != resource && DamUtil.isAsset(resource)) {
            return (Asset)resource.adaptTo(Asset.class);
        }
        Resource parent = ResourceUtil.getParent((Resource)resource);
        if (null != parent) {
            return DamUtil.resolveToAsset(parent);
        }
        return null;
    }

    public static void setModified(Asset asset, String user, Calendar date) {
        try {
            Node contentNode = ((Node)asset.adaptTo(Node.class)).getNode("jcr:content");
            contentNode.setProperty("jcr:lastModifiedBy", user);
            contentNode.setProperty("jcr:lastModified", date);
            contentNode.getSession().save();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public static List<String> findExpiringAssets(Session session, Calendar lowerBound, Calendar upperBound) throws RepositoryException {
        ArrayList<String> results = null;
        QueryObjectModel qom = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            QueryObjectModelFactory qomf = queryManager.getQOMFactory();
            Selector damAsset = qomf.selector("dam:Asset", "selector_0");
            Selector assetContent = qomf.selector("dam:AssetContent", "selector_1");
            ValueFactory vf = session.getValueFactory();
            PropertyValue expiryDateOprnd = qomf.propertyValue("selector_1", "offTime");
            Object expiryDateConstrnt = null;
            Comparison upperBndConstrnt = null;
            if (upperBound != null) {
                Literal upperBndOprnd = qomf.literal(vf.createValue(upperBound));
                expiryDateConstrnt = upperBndConstrnt = qomf.comparison((DynamicOperand)expiryDateOprnd, "jcr.operator.less.than", (StaticOperand)upperBndOprnd);
            }
            if (lowerBound != null) {
                Literal lowerBndOprnd = qomf.literal(vf.createValue(lowerBound));
                Comparison lowerBndConstrnt = qomf.comparison((DynamicOperand)expiryDateOprnd, "jcr.operator.greater.than.or.equal.to", (StaticOperand)lowerBndOprnd);
                expiryDateConstrnt = upperBndConstrnt != null ? qomf.and((Constraint)upperBndConstrnt, (Constraint)lowerBndConstrnt) : lowerBndConstrnt;
            }
            SameNodeJoinCondition joinAssetToJcrContent = qomf.sameNodeJoinCondition("selector_1", "selector_0", "jcr:content");
            assetContent = qomf.join((Source)damAsset, (Source)assetContent, "jcr.join.type.inner", (JoinCondition)joinAssetToJcrContent);
            qom = qomf.createQuery((Source)assetContent, (Constraint)expiryDateConstrnt, null, null);
            if (log.isDebugEnabled()) {
                log.debug("Expiring assets query [{}].", (Object)qom.getStatement());
            }
            long startTime = 0L;
            if (log.isTraceEnabled()) {
                startTime = System.currentTimeMillis();
            }
            QueryResult result = qom.execute();
            if (log.isTraceEnabled()) {
                long endTime = System.currentTimeMillis();
                log.trace("Time taken to execute query [{}] ms", (Object)new Long(endTime - startTime));
            }
            RowIterator rowIter = result.getRows();
            long resultSize = rowIter.getSize();
            results = new ArrayList<String>(new Long(resultSize).intValue());
            if (log.isDebugEnabled()) {
                log.debug("ResultSet size [{}].", (Object)resultSize);
            }
            if (log.isTraceEnabled()) {
                log.trace("Logging search result set");
            }
            while (rowIter.hasNext()) {
                Row row = rowIter.nextRow();
                Node node = row.getNode("selector_0");
                String path = node.getPath();
                if (log.isTraceEnabled()) {
                    log.trace("path  [{}]", (Object)path);
                }
                results.add(path);
            }
        }
        catch (RepositoryException e) {
            if (qom != null) {
                log.error("Expired assets query [{}].", (Object)qom.getStatement());
            }
            log.error("Error in finding expired assets", (Throwable)e);
            throw e;
        }
        return results;
    }

    public static String getValue(Node n, String name, String defaultValue) throws RepositoryException {
        if (n == null) {
            return defaultValue;
        }
        try {
            Property p = n.getProperty(name);
            if (!p.isMultiple()) {
                return p.getString();
            }
            Value[] values = p.getValues();
            String val = "";
            boolean first = true;
            for (Value a : values) {
                if (!first) {
                    val = val + ", ";
                } else {
                    first = false;
                }
                val = val + a.getString();
            }
            return val;
        }
        catch (PathNotFoundException pathNotFoundException) {
            return defaultValue;
        }
    }
}

