/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.OrientationUtil;
import com.day.image.Layer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebEnabledImageCreator {
    private static final Logger log = LoggerFactory.getLogger(WebEnabledImageCreator.class);
    private static final String WEB_SPECIFIER = "web";
    private Asset asset;
    private MimeTypeService mimeTypeService;

    public WebEnabledImageCreator(Asset asset, MimeTypeService mimeTypeService) {
        this.asset = asset;
        this.mimeTypeService = mimeTypeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(BufferedImage image, String defaultMimetype, String dimensions, String keepFormat, String qualityStr, boolean force) throws RepositoryException, IOException {
        block5: {
            String renditionName;
            Layer layer;
            double quality;
            String mimetype;
            block3: {
                block4: {
                    int maxWidth = this.getDimension(dimensions)[0];
                    int maxHeight = this.getDimension(dimensions)[1];
                    String oriMimeType = this.getMimeType(this.asset);
                    mimetype = StringUtils.isNotBlank((String)oriMimeType) && keepFormat.contains(oriMimeType) ? oriMimeType : defaultMimetype;
                    quality = mimetype.equals("image/gif") ? this.getQuality(255.0, qualityStr) : this.getQuality(1.0, qualityStr);
                    layer = this.createImage(image, maxWidth, maxHeight);
                    if (OrientationUtil.hasOrientationMetadata(this.asset)) {
                        OrientationUtil.adjustOrientation(this.asset, layer);
                    }
                    renditionName = "cq5dam.web." + maxWidth + "." + maxHeight + "." + this.getExtension(mimetype);
                    if (!StringUtils.contains((String)keepFormat, (String)oriMimeType)) break block3;
                    if (image.getHeight() != layer.getHeight() || image.getWidth() != layer.getWidth() || force) break block4;
                    InputStream oriIs = null;
                    try {
                        oriIs = ((Node)this.asset.getOriginal().adaptTo(Node.class)).getProperty("jcr:content/jcr:data").getBinary().getStream();
                        this.asset.addRendition(renditionName, oriIs, mimetype);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(oriIs);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)oriIs);
                    break block5;
                }
                this.saveImage(this.asset, layer, mimetype, quality, renditionName);
                break block5;
            }
            this.saveImage(this.asset, layer, mimetype, quality, renditionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImage(Asset asset, Layer layer, String mimetype, double quality, String renditionName) throws IOException {
        File tmpFile = File.createTempFile(WEB_SPECIFIER, "." + this.getExtension(mimetype));
        FileOutputStream out = FileUtils.openOutputStream((File)tmpFile);
        FileInputStream is = null;
        try {
            layer.write(mimetype, quality, (OutputStream)out);
            is = FileUtils.openInputStream((File)tmpFile);
            asset.addRendition(renditionName, (InputStream)is, mimetype);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly(is);
            FileUtils.deleteQuietly((File)tmpFile);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)is);
        FileUtils.deleteQuietly((File)tmpFile);
    }

    protected Layer createImage(BufferedImage image, int maxWidth, int maxHeight) {
        long startTime = System.currentTimeMillis();
        Layer layer = new Layer(image);
        int height = layer.getHeight();
        int width = layer.getWidth();
        if (height > maxHeight || width > maxWidth) {
            int newWidth;
            int newHeight;
            if (height > width) {
                newHeight = maxHeight;
                newWidth = Math.round((float)width * (float)maxHeight / (float)height);
                if (newWidth > maxWidth) {
                    newWidth = maxWidth;
                    newHeight = Math.round((float)height * (float)maxWidth / (float)width);
                }
            } else {
                newWidth = maxWidth;
                newHeight = Math.round((float)height * (float)maxWidth / (float)width);
                if (newHeight > maxHeight) {
                    newHeight = maxHeight;
                    newWidth = Math.round((float)width * (float)maxHeight / (float)height);
                }
            }
            layer.resize(newWidth, newHeight);
        }
        if (this.asset.getName().endsWith(".gif")) {
            layer.setTransparency(new Color(-991024));
        }
        log.debug("createImage took " + (System.currentTimeMillis() - startTime) + "ms");
        return layer;
    }

    protected String getExtension(String mimetype) {
        return this.mimeTypeService.getExtension(mimetype);
    }

    protected String getMimeType(Asset asset) {
        String name = asset.getName().toLowerCase();
        return this.mimeTypeService.getMimeType(name);
    }

    protected Integer[] getDimension(String dimensions) {
        if (dimensions != null) {
            String[] splits = dimensions.split(":");
            Integer[] d = new Integer[]{Integer.valueOf(splits[0]), Integer.valueOf(splits[1])};
            return d;
        }
        return new Integer[]{1000, 1000};
    }

    protected double getQuality(double base, String qualityStr) {
        int q = Integer.valueOf(qualityStr);
        double res = base * (double)q / 100.0;
        return res;
    }
}

