/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import com.day.cq.commons.DiffInfo;
import com.day.cq.commons.ImageResource;
import com.day.cq.commons.SlingRepositoryException;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.commons.RequestHelper;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.image.Layer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

public abstract class AbstractImageServlet
extends SlingSafeMethodsServlet {
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            if (this.checkModifiedSince(request, response)) {
                return;
            }
            String type = this.getImageType(request.getRequestPathInfo().getExtension());
            if (type == null) {
                response.sendError(404, "Image type not supported");
                return;
            }
            ImageContext context = new ImageContext(request, type);
            Layer layer = this.createLayer(context);
            if (layer != null) {
                this.applyDiff(layer, context);
            }
            this.writeLayer(request, response, context, layer);
        }
        catch (RepositoryException e) {
            throw new SlingRepositoryException(e);
        }
    }

    protected void writeLayer(SlingHttpServletRequest request, SlingHttpServletResponse response, ImageContext context, Layer layer) throws IOException, RepositoryException {
        this.writeLayer(request, response, context, layer, this.getImageQuality());
    }

    protected void writeLayer(SlingHttpServletRequest request, SlingHttpServletResponse response, ImageContext context, Layer layer, double quality) throws IOException, RepositoryException {
        String imageType = this.getImageType();
        if (context != null && context.requestImageType != null && context.requestImageType.startsWith("image/")) {
            imageType = context.requestImageType;
        }
        response.setContentType(imageType);
        int size = layer.getHeight() * layer.getWidth();
        if (size < 0x100000) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(size);
            layer.write(imageType, quality, (OutputStream)out);
            byte[] bytes = out.toByteArray();
            response.setContentLength(bytes.length);
            response.getOutputStream().write(bytes);
        } else {
            layer.write(imageType, quality, (OutputStream)response.getOutputStream());
        }
    }

    protected String getImageType() {
        return "image/png";
    }

    protected String getImageType(String ext) {
        if ("png".equals(ext)) {
            return "image/png";
        }
        if ("gif".equals(ext)) {
            return "image/gif";
        }
        if ("jpg".equals(ext) || "jpeg".equals(ext)) {
            return "image/jpg";
        }
        return null;
    }

    protected double getImageQuality() {
        return 1.0;
    }

    protected boolean checkModifiedSince(SlingHttpServletRequest req, SlingHttpServletResponse resp) {
        return RequestHelper.handleIfModifiedSince((HttpServletRequest)req, (HttpServletResponse)resp, (Node)req.getResource().adaptTo(Node.class));
    }

    protected abstract Layer createLayer(ImageContext var1) throws RepositoryException, IOException;

    protected boolean applyDiff(Layer layer, ImageContext c) {
        if (layer == null || c.diffInfo == null) {
            return false;
        }
        if (c.diffInfo.getType() == DiffInfo.TYPE.REMOVED) {
            layer.setPaint((Paint)Color.RED);
            layer.setStroke((Stroke)new BasicStroke(2.0f));
            layer.drawLine(0.0f, 0.0f, (float)layer.getWidth(), (float)layer.getHeight());
            layer.drawLine((float)layer.getWidth(), 0.0f, 0.0f, (float)layer.getHeight());
            return true;
        }
        if (c.diffInfo.getType() == DiffInfo.TYPE.ADDED) {
            layer.setPaint((Paint)Color.GREEN);
            layer.setStroke((Stroke)new BasicStroke(3.0f));
            layer.drawRect((Rectangle2D)new Rectangle(layer.getWidth(), layer.getHeight()));
            return true;
        }
        if (this.isModifiedDiff(c)) {
            layer.setPaint((Paint)Color.RED);
            layer.setStroke((Stroke)new BasicStroke(3.0f));
            layer.drawRect((Rectangle2D)new Rectangle(layer.getWidth(), layer.getHeight()));
            return true;
        }
        return false;
    }

    protected ImageResource createImageResource(Resource resource) {
        return new ImageResource(resource);
    }

    protected boolean isModifiedDiff(ImageContext c) {
        Dimension d1;
        if (c.diffInfo == null || c.diffInfo.getContent() == null) {
            return false;
        }
        ImageResource img0 = this.createImageResource(c.resource);
        if (!img0.hasContent()) {
            return false;
        }
        ImageResource img1 = this.createImageResource(c.diffInfo.getContent());
        if (!img1.hasContent()) {
            return false;
        }
        try {
            Calendar c0 = img0.getLastModified();
            Calendar c1 = img1.getLastModified();
            if (!(c0 == c1 || c0 != null && c0.equals(c1))) {
                return true;
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        Rectangle r0 = img0.getCropRect();
        Rectangle r1 = img1.getCropRect();
        if (!(r0 == r1 || r0 != null && r0.equals(r1))) {
            return true;
        }
        if (img0.getRotation() != img1.getRotation()) {
            return true;
        }
        Dimension d0 = new Dimension(img0.get(img0.getItemName("width"), 0), img0.get(img0.getItemName("height"), 0));
        return !d0.equals(d1 = new Dimension(img1.get(img1.getItemName("width"), 0), img1.get(img1.getItemName("height"), 0)));
    }

    public static class ImageContext {
        public final SlingHttpServletRequest request;
        public final Resource resource;
        public final ResourceResolver resolver;
        public final Node node;
        public final ValueMap properties;
        public final Style style;
        public final Page currentPage;
        public final ValueMap pageProperties;
        public final Component component;
        public final String requestImageType;
        public final DiffInfo diffInfo;

        public ImageContext(SlingHttpServletRequest request, String type) {
            String vLabel;
            this.request = request;
            this.resource = request.getResource();
            this.resolver = request.getResourceResolver();
            this.node = (Node)this.resource.adaptTo(Node.class);
            ValueMap props = (ValueMap)this.resource.adaptTo(ValueMap.class);
            this.properties = props == null ? ValueMap.EMPTY : props;
            this.style = WCMUtils.getStyle(request);
            PageManager pageManager = (PageManager)this.resolver.adaptTo(PageManager.class);
            this.currentPage = pageManager.getContainingPage(this.resource);
            this.pageProperties = this.currentPage == null ? ValueMap.EMPTY : this.currentPage.getProperties();
            this.component = WCMUtils.getComponent(this.resource);
            this.requestImageType = type;
            Resource vRes = null;
            DiffInfo.TYPE diffType = null;
            String vType = request.getParameter("cq_diffType");
            if (vType != null) {
                try {
                    diffType = DiffInfo.TYPE.valueOf((String)vType);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if ((vLabel = request.getParameter("cq_diffTo")) != null && (vRes = DiffInfo.getVersionedResource((Resource)this.resource, (String)vLabel)) == null && diffType == null && !this.resource.getPath().contains("jcr:frozenNode")) {
                diffType = DiffInfo.TYPE.ADDED;
            }
            this.diffInfo = vRes != null || diffType != null ? new DiffInfo(vRes, diffType == null ? DiffInfo.TYPE.SAME : diffType) : null;
        }
    }
}

