/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.contentsync.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.contentsync.PageExporter;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageExportServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 468624717845030082L;
    private static final Logger log = LoggerFactory.getLogger(PageExportServlet.class);
    private PageExporter exporter;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Page page = (Page)request.getResource().adaptTo(Page.class);
        try {
            this.exporter.export(page, request, (HttpServletResponse)response);
        }
        catch (WCMException e) {
            log.error("Page export failed: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void bindExporter(PageExporter pageExporter) {
        this.exporter = pageExporter;
    }

    protected void unbindExporter(PageExporter pageExporter) {
        if (this.exporter == pageExporter) {
            this.exporter = null;
        }
    }
}

