/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.contentsync.impl.handler;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.contentsync.config.ConfigEntry;
import com.day.cq.contentsync.handler.ContentUpdateHandler;
import com.day.cq.wcm.foundation.Image;
import com.day.text.Text;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageResourceUpdateHandler
implements ContentUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(ImageResourceUpdateHandler.class);
    private JcrResourceResolverFactory resolverFactory;

    public boolean updateCacheEntry(ConfigEntry configEntry, Long lastUpdated, String configCacheRoot, Session admin, Session session) {
        ResourceResolver resolver = this.resolverFactory.getResourceResolver(admin);
        Resource resource = resolver.getResource(configEntry.getContentPath());
        Image img = new Image(resource);
        img.setItemName("file", "image");
        img.setItemName("fileReference", "imageReference");
        img.setSelector("img");
        try {
            if (img.getLastModified() == null || lastUpdated < img.getLastModified().getTime().getTime()) {
                String src = img.getSrc();
                String parentPath = configCacheRoot + Text.getRelativeParent((String)src, (int)1);
                Node parent = JcrUtil.createPath((String)parentPath, (String)"sling:Folder", (Session)admin);
                Node image = (Node)resolver.getResource(resource.getPath() + "/image").adaptTo(Node.class);
                JcrUtil.copy((Node)image, (Node)parent, (String)Text.getName((String)src));
                admin.save();
                return true;
            }
        }
        catch (RepositoryException e) {
            log.error("Unexpected error while updating logo: ", (Throwable)e);
        }
        return false;
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

