/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.lang3.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sitemap {
    private LinkedList<Link> links = new LinkedList();

    public Sitemap(Page rootPage) {
        this.buildLinkAndChildren(rootPage, 0);
    }

    private void buildLinkAndChildren(Page page, int level) {
        if (page != null) {
            String title = page.getTitle();
            if (title == null) {
                title = page.getName();
            }
            this.links.add(new Link(page.getPath(), title, level));
            Iterator children = page.listChildren((Filter)new PageFilter());
            while (children.hasNext()) {
                Page child = (Page)children.next();
                this.buildLinkAndChildren(child, level + 1);
            }
        }
    }

    public void draw(Writer w) throws IOException {
        PrintWriter out = new PrintWriter(w);
        int previousLevel = -1;
        for (Link aLink : this.links) {
            if (aLink.getLevel() > previousLevel) {
                out.print("<div class=\"linkcontainer\">");
            } else if (aLink.getLevel() < previousLevel) {
                for (int i = aLink.getLevel(); i < previousLevel; ++i) {
                    out.print("</div>");
                }
            }
            out.printf("<div class=\"link\"><a href=\"%s.html\">%s</a></div>", StringEscapeUtils.escapeHtml4((String)aLink.getPath()), aLink.getTitle());
            previousLevel = aLink.getLevel();
        }
        for (int i = -1; i < previousLevel; ++i) {
            out.print("</div>");
        }
    }

    public LinkedList<Link> getLinks() {
        return this.links;
    }

    public class Link {
        private String path;
        private String title;
        private int level;

        public Link(String path, String title, int level) {
            this.path = path;
            this.title = title;
            this.level = level;
        }

        public String getPath() {
            return this.path;
        }

        public int getLevel() {
            return this.level;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

