/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.commons.PathInfo;
import com.day.cq.personalization.ProfileProvider;
import com.day.cq.security.profile.Profile;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormChooserProfileProvider
implements ProfileProvider {
    private static final Logger log = LoggerFactory.getLogger(FormChooserProfileProvider.class);

    public Profile getProfile(SlingHttpServletRequest request) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        Resource resource = request.getResource();
        try {
            PathInfo info = new PathInfo(new URI(request.getRequestURI()).getPath());
            if (!info.getResourcePath().equals(resource.getPath())) {
                log.debug("Found FormChooser request for {} to {}", (Object)resource.getPath(), (Object)info.getResourcePath());
                resource = resourceResolver.getResource(info.getResourcePath());
            }
            if (resource != null) {
                return (Profile)resource.adaptTo(Profile.class);
            }
        }
        catch (URISyntaxException e) {
            log.warn("Found request with invalid syntax fall back to request's resource {}", (Object)resource.getPath());
        }
        return null;
    }

    public Profile getProfile(ResourceResolver resolver) {
        return null;
    }
}

