/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.wcm.foundation.forms.FormsHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormParagraphPostProcessor
implements SlingPostProcessor {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String PAGE_MARKER = "/jcr:content/";

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        HashSet<String> fixPaths = new HashSet<String>();
        for (Modification mod : changes) {
            switch (mod.getType()) {
                case ORDER: 
                case MOVE: 
                case COPY: {
                    break;
                }
                case MODIFY: 
                case CREATE: 
                case DELETE: {
                    int pageEndPos = mod.getSource().indexOf("/jcr:content/");
                    if (pageEndPos == -1) break;
                    String pagePath = mod.getSource().substring(0, pageEndPos);
                    fixPaths.add(pagePath);
                }
            }
        }
        ResourceResolver resolver = request.getResourceResolver();
        for (String pagePath : fixPaths) {
            String contentPath = pagePath + '/' + "jcr:content";
            this.logger.debug("Checking page for form paragraphs {}", (Object)pagePath);
            Resource contentResource = resolver.getResource(contentPath);
            if (contentResource == null) continue;
            this.fixStructure(contentResource);
        }
    }

    private void fixStructure(Resource contentResource) throws RepositoryException {
        Iterator rI = ResourceUtil.listChildren((Resource)contentResource);
        while (rI.hasNext()) {
            Resource res = (Resource)rI.next();
            if (ResourceUtil.isA((Resource)res, (String)"foundation/components/form/start") || ResourceUtil.isA((Resource)res, (String)"foundation/components/form/end")) {
                if (FormsHelper.checkFormStructure(res) == null) continue;
                this.logger.debug("Fixed forms structure at {}", (Object)contentResource.getPath());
                continue;
            }
            this.fixStructure(res);
        }
    }
}

