/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.wcm.foundation.forms.FieldHelper;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import com.day.cq.wcm.foundation.forms.impl.FormsHandlingRequest;
import com.day.cq.wcm.foundation.forms.impl.FormsHandlingResponse;
import com.day.cq.wcm.foundation.forms.impl.RedirectRequest;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormsHandlingServlet
extends SlingAllMethodsServlet
implements OptingServlet,
Filter {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String EXTENSION = "html";
    protected static final String SELECTOR = "form";
    protected static final String ATTR_RESOURCE = FormsHandlingServlet.class.getName() + "/resource";

    public boolean accepts(SlingHttpServletRequest request) {
        return EXTENSION.equals(request.getRequestPathInfo().getExtension());
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String actionType;
        if (ResourceUtil.isNonExistingResource((Resource)request.getResource()) || request.getAttribute(ATTR_RESOURCE) == null) {
            this.logger.debug("Received fake request!");
            response.setStatus(500);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Validating POST request with form definition stored at {}.", (Object)request.getResource().getPath());
        }
        FormsHandlingRequest formsRequest = new FormsHandlingRequest((SlingHttpServletRequest)request);
        FormsHandlingResponse formsResponse = new FormsHandlingResponse(response);
        Resource formResource = request.getResource();
        FormsHelper.getFormId(request);
        ValidationInfo info = this.validate((SlingHttpServletRequest)formsRequest, (SlingHttpServletResponse)formsResponse, formResource);
        ValueMap properties = ResourceUtil.getValueMap((Resource)formResource);
        String string = actionType = properties == null ? "" : (String)properties.get("actionType", (Object)"");
        if (actionType.length() == 0) {
            info = ValidationInfo.createValidationInfo(request);
            info.addErrorMessage(null, "Unable to process the form: missing actionType");
        }
        if (info != null) {
            this.logger.debug("Form {} is not valid: {}", (Object)formResource.getPath(), (Object)info);
            Resource rsrc = (Resource)request.getAttribute(ATTR_RESOURCE);
            request.removeAttribute(ATTR_RESOURCE);
            request.getRequestDispatcher(rsrc).forward((ServletRequest)formsRequest, (ServletResponse)response);
            return;
        }
        FormsHelper.runAction(actionType, "forward", formResource, (SlingHttpServletRequest)formsRequest, (SlingHttpServletResponse)formsResponse);
        String forwardPath = FormsHelper.getForwardPath(request);
        if (forwardPath != null && forwardPath.length() > 0) {
            String redirect;
            if (FormsHelper.isRedirectToReferrer((ServletRequest)request) && request.getParameter(":redirect") == null) {
                request = new RedirectRequest((SlingHttpServletRequest)request, FormsHelper.getReferrer((HttpServletRequest)request));
            }
            if ((redirect = FormsHelper.getForwardRedirect((ServletRequest)request)) != null) {
                request = new RedirectRequest((SlingHttpServletRequest)request, redirect);
            }
            if (forwardPath.endsWith("/")) {
                forwardPath = forwardPath + '*';
            }
            Resource forwardResource = request.getResourceResolver().resolve(forwardPath);
            request.getRequestDispatcher(forwardResource, FormsHelper.getForwardOptions((ServletRequest)request)).forward((ServletRequest)request, (ServletResponse)response);
            FormsHelper.runAction(actionType, "cleanup", formResource, (SlingHttpServletRequest)formsRequest, (SlingHttpServletResponse)formsResponse);
            return;
        }
        FormsHelper.runAction(actionType, "post", formResource, request, response);
    }

    private ValidationInfo validate(SlingHttpServletRequest request, SlingHttpServletResponse response, final Resource formResource) throws ServletException, IOException {
        Iterator<Resource> iter = FormsHelper.getFormElements(formResource);
        while (iter.hasNext()) {
            Resource formField = iter.next();
            FieldHelper.initializeField(request, response, formField);
            FormsHelper.includeResource(request, response, formField, "servervalidation");
        }
        ValueMap properties = ResourceUtil.getValueMap((Resource)formResource);
        final String valScriptRT = (String)properties.get("validationRT", (Object)formResource.getResourceType());
        if (valScriptRT != null && valScriptRT.length() > 0) {
            Object valScriptResource = formResource;
            if (!formResource.getResourceType().equals(valScriptRT)) {
                valScriptResource = new ResourceWrapper(formResource){

                    public String getResourceType() {
                        return valScriptRT;
                    }

                    public String getResourceSuperType() {
                        return formResource.getResourceType();
                    }
                };
            }
            FormsHelper.includeResource(request, response, valScriptResource, "formservervalidation");
        }
        return ValidationInfo.getValidationInfo((HttpServletRequest)request);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest req;
        if (request instanceof SlingHttpServletRequest && "POST".equalsIgnoreCase((req = (SlingHttpServletRequest)request).getMethod()) && req.getParameter(":formstart") != null) {
            req.setAttribute(ATTR_RESOURCE, (Object)req.getResource());
            StringBuilder sb = new StringBuilder();
            String formPath = req.getParameter(":formstart");
            if (!formPath.startsWith("/")) {
                sb.append(req.getResource().getPath());
                sb.append('/');
            }
            sb.append(formPath);
            sb.append('.');
            sb.append(SELECTOR);
            sb.append('.');
            sb.append(EXTENSION);
            String forwardPath = sb.toString();
            req.getRequestDispatcher(forwardPath).forward(request, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
    }
}

