/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.impl;

import com.day.cq.statistics.StatisticsService;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.core.stats.PageView;
import com.day.crx.statistics.Entry;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageImpressionsTracker
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -7915330057389423541L;
    private static final Logger log = LoggerFactory.getLogger(PageImpressionsTracker.class);
    private static final String PATH_PARAMETER = "path";
    private static final String STATISTICS_PATH = "/pages";
    private StatisticsService statisticsService;
    private SlingRepository repository;
    private JcrResourceResolverFactory resolverFactory;
    private Session session;
    private String statisticsPath;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestParameter[] parameter = request.getRequestParameters(PATH_PARAMETER);
        response.setContentType("text/javascript");
        response.setHeader("cache-control", "no-store");
        if (parameter != null) {
            try {
                Session session = this.getSession();
                ResourceResolver resolver = this.resolverFactory.getResourceResolver(session);
                for (RequestParameter path : parameter) {
                    try {
                        Resource resource = resolver.getResource(path.getString());
                        if (resource == null || resource.adaptTo(Page.class) == null) continue;
                        PageView view = new PageView(this.statisticsPath, (Page)resource.adaptTo(Page.class), WCMMode.DISABLED);
                        this.statisticsService.addEntry((Entry)view);
                    }
                    catch (RepositoryException e) {
                        log.error("Failed to add entry for {}: {}", (Object)path.getString(), (Object)e);
                    }
                }
            }
            catch (RepositoryException e) {
                log.error("Failed to access Repository to add statistics: {}", (Throwable)e);
            }
        }
        response.getWriter().println("//impression added");
    }

    protected void activate(ComponentContext ctx) {
        this.statisticsPath = this.statisticsService.getPath() + STATISTICS_PATH;
    }

    protected void deactivate(ComponentContext ctx) {
        if (this.session != null) {
            this.session.logout();
        }
    }

    private synchronized Session getSession() throws RepositoryException {
        if (this.session == null || !this.session.isLive()) {
            this.session = this.repository.loginAdministrative(null);
        }
        return this.session;
    }

    protected void bindStatisticsService(StatisticsService statisticsService) {
        this.statisticsService = statisticsService;
    }

    protected void unbindStatisticsService(StatisticsService statisticsService) {
        if (this.statisticsService == statisticsService) {
            this.statisticsService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

