/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.profile.impl;

import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.commons.AbstractImageServlet;
import com.day.cq.wcm.foundation.Image;
import com.day.image.Layer;
import com.day.text.Text;
import java.awt.Paint;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

public class ProfileImages
extends AbstractImageServlet {
    private static final int ICON_WIDTH = 48;
    private static final int ICON_HEIGHT = 48;
    private static final String THUMBNAIL = "thumbnail";

    protected Layer createLayer(AbstractImageServlet.ImageContext c) throws RepositoryException, IOException {
        Image image = new Image(c.resource.getResourceResolver().getResource(c.resource, ".."));
        image.setItemName("file", Text.getName((String)c.resource.getPath()));
        if (!image.hasContent()) {
            return null;
        }
        String[] selectors = c.request.getRequestPathInfo().getSelectors();
        int width = 0;
        try {
            width = Integer.parseInt(selectors[2]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (width == 0) {
            width = 48;
        }
        int height = width;
        if (selectors.length > 1 && THUMBNAIL.equals(selectors[1])) {
            float ratio;
            Layer org = image.getLayer(false, false, false);
            int w = org.getWidth();
            int h = org.getHeight();
            if (h < height && w < width) {
                org.setX((int)Math.floor((width - w) / 2));
                org.setY((int)Math.floor((height - h) / 2));
            } else if (h == w && width == height) {
                org.resize(width, height);
            } else if (h > w) {
                ratio = (float)h / (float)height;
                w = (int)Math.floor((float)w / ratio);
                org.resize(w, height);
                org.setX((int)Math.floor((width - w) / 2));
            } else {
                ratio = (float)w / (float)width;
                h = (int)Math.floor((float)h / ratio);
                org.resize(width, h);
                org.setY((int)Math.floor((height - h) / 2));
            }
            Layer outLayer = new Layer(width, height, (Paint)org.getBackgroundColor());
            outLayer.setTransparency(org.getBackgroundColor());
            outLayer.merge(org);
            return outLayer;
        }
        Style style = this.getStyle(c);
        if (style != null) {
            image.loadStyleData(style);
        }
        return image.getLayer(false, true, false);
    }

    protected void writeLayer(SlingHttpServletRequest request, SlingHttpServletResponse response, AbstractImageServlet.ImageContext context, Layer layer) throws IOException, RepositoryException {
        if (layer == null) {
            response.sendError(404);
        } else {
            super.writeLayer(request, response, context, layer);
        }
    }

    private Style getStyle(AbstractImageServlet.ImageContext c) {
        String designId = "";
        String cellPath = "";
        String suffix = c.request.getRequestPathInfo().getSuffix();
        if (suffix != null && suffix.length() > 0) {
            int idx;
            if (!suffix.startsWith("/")) {
                suffix = "/" + suffix;
            }
            if ((idx = suffix.indexOf("/-/")) >= 0) {
                designId = suffix.substring(0, idx);
                cellPath = suffix.substring(idx + 3);
            } else {
                designId = suffix;
            }
        }
        Design design = null;
        if (designId.length() > 0) {
            Designer d = (Designer)c.resolver.adaptTo(Designer.class);
            design = d.getDesign(designId);
        }
        if (design == null) {
            return null;
        }
        if (cellPath.length() > 0) {
            return design.getStyle(cellPath);
        }
        return design.getStyle(Text.getName((String)c.resource.getPath()));
    }

    protected String getImageType(String ext) {
        if ("res".equals(ext)) {
            return "res";
        }
        return super.getImageType(ext);
    }
}

