/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.foundation.ELEvaluator;
import com.day.cq.wcm.foundation.forms.FieldHelper;
import com.day.cq.wcm.foundation.forms.FormResourceEdit;
import com.day.cq.wcm.foundation.forms.FormsConstants;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import com.day.cq.wcm.foundation.forms.impl.FormsManagerImpl;
import com.day.cq.wcm.foundation.forms.impl.FormsUtil;
import com.day.cq.wcm.foundation.forms.impl.JspSlingHttpServletResponseWrapper;
import com.day.cq.wcm.foundation.forms.impl.ResourceWrapper;
import com.day.cq.widget.HtmlLibraryManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.jcr.JsonItemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FormsHelper.class.getName());
    public static final String REQ_ATTR_GLOBAL_LOAD_MAP = "cq.form.loadmap";
    public static final String REQ_ATTR_GLOBAL_LOAD_RESOURCE = "cq.form.loadresource";
    public static final String REQ_ATTR_EDIT_RESOURCES = "cq.form.editresources";
    public static final String REQ_ATTR_CLIENT_VALIDATION = "cq.form.clientvalidation";
    public static final String REQ_ATTR_FORMID = "cq.form.id";
    public static final String REQ_ATTR_WRITTEN_JAVASCRIPT = "cq.form.javascript";
    public static final String REQ_ATTR_ACTION_SUFFIX = "cq.form.action.suffix";
    public static final String REQ_ATTR_FORWARD_PATH = "cq.form.forward.path";
    public static final String REQ_ATTR_FORWARD_OPTIONS = "cq.form.forward.options";
    public static final String REQ_ATTR_IS_INIT = "cq.form.init";
    public static final String REQ_ATTR_READ_ONLY = "cq.form.readonly";
    public static final String REQ_ATTR_REDIRECT = "cq.form.redirect";
    public static final String REQ_ATTR_REDIRECT_TO_REFERRER = FormsConstants.REQUEST_ATTR_REDIRECT_TO_REFERRER;

    private FormsHelper() {
    }

    @Deprecated
    public static void startForm(SlingHttpServletRequest request, SlingHttpServletResponse response, JspWriter out) throws IOException, ServletException {
        FormsHelper.startForm(request, (SlingHttpServletResponse)new JspSlingHttpServletResponseWrapper(response, out));
    }

    public static void startForm(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        String actionType;
        Resource formResource = request.getResource();
        FormsHelper.initialize(request, formResource, response);
        FormsHelper.writeJavaScript(request, response, formResource);
        String formId = FormsHelper.getFormId(request);
        PrintWriter out = response.getWriter();
        String url = request.getRequestURI();
        String suffix = FormsHelper.getActionSuffix(request);
        if (StringUtils.isNotBlank((String)suffix)) {
            url = url + (suffix.startsWith("/") ? suffix : "/" + suffix);
        }
        out.print("<form method=\"POST\" action=\"");
        out.print(url);
        out.print("\" id=\"");
        out.print(StringEscapeUtils.escapeHtml4((String)formId));
        out.print("\" name=\"");
        out.print(StringEscapeUtils.escapeHtml4((String)formId));
        out.print("\" enctype=\"multipart/form-data\">");
        out.print("<input type=\"hidden\" name=\"");
        out.print(":formid");
        out.print("\" value=\"");
        out.print(StringEscapeUtils.escapeHtml4((String)formId));
        out.print("\"/>");
        out.print("<input type=\"hidden\" name=\"");
        out.print(":formstart");
        out.print("\" value=\"");
        if (formResource.getPath().startsWith(url)) {
            out.print(formResource.getPath().substring(url.length() + 1));
        } else {
            out.print(formResource.getPath());
        }
        out.print("\"/>");
        out.print("<input type=\"hidden\" name=\"_charset_\" value=\"UTF-8\"/>");
        ValueMap properties = ResourceUtil.getValueMap((Resource)formResource);
        String redirect = (String)properties.get("redirect", (Object)"");
        if (redirect.length() > 0) {
            int lastSlash;
            if (redirect.startsWith("/") && request.getContextPath() != null && request.getContextPath().length() > 0 && !redirect.startsWith(request.getContextPath())) {
                redirect = request.getContextPath() + redirect;
            }
            if (redirect.indexOf(46, lastSlash = redirect.lastIndexOf(47)) == -1) {
                redirect = redirect + ".html";
            }
            out.print("<input type=\"hidden\" name=\":redirect\" value=\"");
            out.print(StringEscapeUtils.escapeHtml4((String)redirect));
            out.print("\"/>");
        }
        if ((actionType = (String)properties.get("actionType", (Object)"")).length() > 0) {
            FormsHelper.runAction(actionType, "addfields", formResource, request, response);
        }
    }

    private static void initialize(SlingHttpServletRequest request, Resource formResource, SlingHttpServletResponse response) throws IOException, ServletException {
        String actionType;
        ValueMap properties = ResourceUtil.getValueMap((Resource)formResource);
        Boolean clientValidation = (Boolean)properties.get("clientValidation", (Object)Boolean.FALSE);
        request.setAttribute(REQ_ATTR_CLIENT_VALIDATION, (Object)clientValidation);
        request.setAttribute(REQ_ATTR_FORMID, properties.get("formid", (Object)"new_form"));
        request.setAttribute(REQ_ATTR_IS_INIT, (Object)"true");
        if (response != null && (actionType = (String)properties.get("actionType", (Object)"foundation/components/form/actions/store")).length() != 0) {
            FormsHelper.runAction(actionType, "init", formResource, request, response);
        }
        if (request.getAttribute(REQ_ATTR_GLOBAL_LOAD_MAP) == null) {
            Resource loadResource = null;
            String loadPath = (String)properties.get("loadPath", (Object)"");
            if (loadPath.length() > 0) {
                loadResource = formResource.getResourceResolver().getResource(loadPath);
            }
            FormsHelper.setFormLoadResource(request, loadResource);
        }
    }

    public static void runAction(String actionType, String scriptName, Resource formResource, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        String rt = actionType;
        if (actionType.indexOf(47) == -1) {
            rt = "foundation/components/form/actions/" + actionType;
        }
        ResourceWrapper includeResource = new ResourceWrapper(formResource, rt, "foundation/components/form/defaults/action");
        FormsHelper.includeResource(request, response, (Resource)includeResource, scriptName);
    }

    private static void checkInit(SlingHttpServletRequest request) {
        if (request.getAttribute(REQ_ATTR_IS_INIT) == null) {
            Resource formStart = FormsHelper.searchFormStart(request.getResource());
            try {
                FormsHelper.initialize(request, formStart, null);
            }
            catch (IOException e) {
            }
            catch (ServletException servletException) {
                // empty catch block
            }
        }
    }

    private static Resource searchFormStart(Resource resource) {
        Resource current;
        if (ResourceUtil.getName((Resource)resource).equals("jcr:content")) {
            return null;
        }
        if (resource.getPath().lastIndexOf("/") == 0) {
            return null;
        }
        if (FormsHelper.checkResourceType(resource, "foundation/components/form/start")) {
            return resource;
        }
        Resource parent = ResourceUtil.getParent((Resource)resource);
        ArrayList<Resource> predecessor = new ArrayList<Resource>();
        Iterator i = ResourceUtil.listChildren((Resource)parent);
        while (i.hasNext() && !(current = (Resource)i.next()).getPath().equals(resource.getPath())) {
            predecessor.add(current);
        }
        Collections.reverse(predecessor);
        for (Resource current2 : predecessor) {
            if (FormsHelper.checkResourceType(current2, "foundation/components/form/start")) {
                return resource;
            }
            if (!FormsHelper.checkResourceType(current2, "foundation/components/form/end")) continue;
            return null;
        }
        return FormsHelper.searchFormStart(parent);
    }

    private static boolean checkResourceType(Resource resource, String type) {
        return ResourceUtil.isA((Resource)resource, (String)type);
    }

    public static void endForm(SlingHttpServletRequest req) {
        FormsHelper.setFormLoadResource(req, null);
        req.removeAttribute(REQ_ATTR_CLIENT_VALIDATION);
        req.removeAttribute(REQ_ATTR_FORMID);
        req.removeAttribute(REQ_ATTR_IS_INIT);
    }

    public static void setForwardPath(SlingHttpServletRequest req, String path) {
        FormsHelper.setForwardPath(req, path, false);
    }

    public static void setForwardPath(SlingHttpServletRequest req, String path, boolean clearFormSelector) {
        req.setAttribute(REQ_ATTR_FORWARD_PATH, (Object)path);
        if (clearFormSelector) {
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            options.setReplaceSelectors("");
            FormsHelper.setForwardOptions((ServletRequest)req, options);
        }
    }

    public static String getForwardPath(SlingHttpServletRequest req) {
        return (String)req.getAttribute(REQ_ATTR_FORWARD_PATH);
    }

    public static void setForwardOptions(ServletRequest req, RequestDispatcherOptions options) {
        req.setAttribute(REQ_ATTR_FORWARD_OPTIONS, (Object)options);
    }

    public static RequestDispatcherOptions getForwardOptions(ServletRequest req) {
        return (RequestDispatcherOptions)req.getAttribute(REQ_ATTR_FORWARD_OPTIONS);
    }

    public static void setForwardRedirect(ServletRequest request, String redirect) {
        request.setAttribute(REQ_ATTR_REDIRECT, (Object)redirect);
    }

    public static String getForwardRedirect(ServletRequest request) {
        return (String)request.getAttribute(REQ_ATTR_REDIRECT);
    }

    public static void setActionSuffix(SlingHttpServletRequest req, String suffix) {
        req.setAttribute(REQ_ATTR_ACTION_SUFFIX, (Object)suffix);
    }

    public static String getActionSuffix(SlingHttpServletRequest req) {
        return (String)req.getAttribute(REQ_ATTR_ACTION_SUFFIX);
    }

    public static void setFormLoadResource(SlingHttpServletRequest req, Resource rsrc) {
        req.removeAttribute(REQ_ATTR_GLOBAL_LOAD_MAP);
        req.removeAttribute(REQ_ATTR_GLOBAL_LOAD_RESOURCE);
        if (rsrc != null) {
            req.setAttribute(REQ_ATTR_GLOBAL_LOAD_RESOURCE, (Object)rsrc);
            ValueMap map = ResourceUtil.getValueMap((Resource)rsrc);
            req.setAttribute(REQ_ATTR_GLOBAL_LOAD_MAP, (Object)map);
        }
    }

    public static Resource getFormLoadResource(SlingHttpServletRequest req) {
        return (Resource)req.getAttribute(REQ_ATTR_GLOBAL_LOAD_RESOURCE);
    }

    public static ValueMap getGlobalFormValues(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        return (ValueMap)req.getAttribute(REQ_ATTR_GLOBAL_LOAD_MAP);
    }

    public static void setFormEditResources(SlingHttpServletRequest req, List<Resource> resources) {
        FormResourceEdit.setResources((ServletRequest)req, resources);
    }

    public static List<Resource> getFormEditResources(SlingHttpServletRequest req) {
        return FormResourceEdit.getResources((ServletRequest)req);
    }

    public static String getFormsPreCheckMethodName(SlingHttpServletRequest req) {
        String formId = FormsHelper.getFormId(req);
        if (formId != null) {
            formId = formId.replaceAll("[\\-]", "_");
        }
        return "cq5forms_preCheck_" + formId;
    }

    private static void writeJavaScript(SlingHttpServletRequest req, SlingHttpServletResponse response, final Resource formResource) throws IOException, ServletException {
        if (FormsHelper.doClientValidation(req)) {
            PrintWriter out = response.getWriter();
            HtmlLibraryManager htmlMgr = FormsManagerImpl.HTML_LIBRARY_MANAGER;
            if (htmlMgr != null) {
                htmlMgr.writeJsInclude(req, (Writer)out, new String[]{"cq.forms"});
            }
            out.println("<script type=\"text/javascript\">");
            if (WCMMode.fromRequest((ServletRequest)req) != WCMMode.DISABLED) {
                out.println("  cq5forms_reloadForPreview = true;");
            }
            out.println("  function " + FormsHelper.getFormsPreCheckMethodName(req) + "(submitid) {");
            out.println("    var dMsgs = \"Please fill out the required field.\";");
            Iterator<Resource> iter = FormsHelper.getFormElements(formResource);
            while (iter.hasNext()) {
                Resource formsField = iter.next();
                FieldHelper.initializeField(req, response, formsField);
                FormsHelper.includeResource(req, response, formsField, "clientvalidation");
            }
            ValueMap properties = ResourceUtil.getValueMap((Resource)formResource);
            final String valScriptRT = (String)properties.get("validationRT", (Object)formResource.getResourceType());
            if (valScriptRT != null && valScriptRT.length() > 0) {
                Object valScriptResource = formResource;
                if (!formResource.getResourceType().equals(valScriptRT)) {
                    valScriptResource = new org.apache.sling.api.resource.ResourceWrapper(formResource){

                        public String getResourceType() {
                            return valScriptRT;
                        }

                        public String getResourceSuperType() {
                            return formResource.getResourceType();
                        }
                    };
                }
                FormsHelper.includeResource(req, response, valScriptResource, "formclientvalidation");
            }
            out.println("    return true;");
            out.println("  }");
            out.println("</script>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void includeResource(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource, String selectorString) throws IOException, ServletException {
        Object oldValue = request.getAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE);
        try {
            request.setAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE, (Object)"true");
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            options.setReplaceSelectors(selectorString);
            request.getRequestDispatcher(resource, options).include((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (oldValue == null) {
                request.removeAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE);
            } else {
                request.setAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE, oldValue);
            }
        }
    }

    public static boolean doClientValidation(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        Boolean value = (Boolean)req.getAttribute(REQ_ATTR_CLIENT_VALIDATION);
        if (value == null) {
            value = Boolean.FALSE;
        }
        return value;
    }

    public static String getFormId(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        return (String)req.getAttribute(REQ_ATTR_FORMID);
    }

    public static String getParameterName(Resource rsrc) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)rsrc);
        String name = (String)properties.get("name", (Object)"");
        if (name.length() == 0) {
            name = ResourceUtil.getName((Resource)rsrc);
            name = FormsUtil.filterElementName(name);
        }
        return name;
    }

    public static String getFieldId(SlingHttpServletRequest req, Resource rsrc) {
        return FormsHelper.getFormId(req) + '_' + FormsHelper.getParameterName(rsrc);
    }

    public static Iterator<Resource> getFormElements(Resource formResource) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        Iterator iter = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)formResource));
        while (!((Resource)iter.next()).getPath().equals(formResource.getPath())) {
        }
        FormsHelper.collectFormElements(list, iter);
        return list.iterator();
    }

    public static Iterator<String> getContentRequestParameterNames(SlingHttpServletRequest req) {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration paramNames = req.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (name.startsWith(":") || name.equals("_charset_")) continue;
            names.add(name);
        }
        return names.iterator();
    }

    private static boolean collectFormElements(List<Resource> list, Iterator<Resource> iter) {
        boolean stop = false;
        while (!stop && iter.hasNext()) {
            Resource n = iter.next();
            if (FormsHelper.checkResourceType(n, "foundation/components/form/end")) {
                stop = true;
                break;
            }
            if (n.getResourceType().startsWith("foundation/components/form/") || n.getResourceSuperType() != null && n.getResourceSuperType().startsWith("foundation/components/form/")) {
                list.add(n);
                continue;
            }
            Iterator cI = ResourceUtil.listChildren((Resource)n);
            if (cI == null) continue;
            stop = FormsHelper.collectFormElements(list, cI);
        }
        return stop;
    }

    public static Resource getResource(SlingHttpServletRequest request, Resource elementResource, String relPath) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List<Resource> editRes = FormResourceEdit.getResources((ServletRequest)request);
        if (editRes != null) {
            resources.addAll(editRes);
        }
        resources.add(elementResource);
        ResourceResolver resolver = request.getResourceResolver();
        for (Resource r : resources) {
            Resource res = resolver.getResource(r, relPath);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static String getValue(SlingHttpServletRequest request, Resource elementResource) {
        return FormsHelper.getValue(request, elementResource, null);
    }

    public static String getValue(SlingHttpServletRequest request, Resource elementResource, String nameParam) {
        String[] values = FormsHelper.getValues(request, elementResource, nameParam);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public static String[] getValues(SlingHttpServletRequest request, Resource elementResource) {
        return FormsHelper.getValues(request, elementResource, null);
    }

    public static String[] getValues(SlingHttpServletRequest request, Resource elementResource, String nameParam) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)elementResource);
        String name = nameParam != null ? nameParam : FormsHelper.getParameterName(elementResource);
        ValidationInfo info = ValidationInfo.getValidationInfo((HttpServletRequest)request);
        if (info != null) {
            return info.getValues(name);
        }
        ValueMap globalFormValues = FormsHelper.getGlobalFormValues(request);
        String[] defaultValues = null;
        String loadPath = (String)properties.get("loadPath", (Object)"");
        if (loadPath.length() > 0) {
            Resource rsrc = request.getResourceResolver().getResource(loadPath);
            if (rsrc != null) {
                defaultValues = (String[])rsrc.adaptTo(String[].class);
            } else if (globalFormValues != null && globalFormValues.get((Object)loadPath) != null) {
                defaultValues = (String[])globalFormValues.get(loadPath, String[].class);
            }
        } else if (globalFormValues != null && globalFormValues.get((Object)name) != null) {
            defaultValues = (String[])globalFormValues.get(name, String[].class);
        }
        if (defaultValues == null) {
            defaultValues = (String[])properties.get("defaultValue", String[].class);
        }
        return defaultValues;
    }

    public static List<String> getValuesAsList(SlingHttpServletRequest request, Resource elementResource) {
        String[] values = FormsHelper.getValues(request, elementResource);
        if (values == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(values);
    }

    public static String getValue(SlingHttpServletRequest request, String name, String defaultValue) {
        String[] values = FormsHelper.getValues(request, name, null);
        if (values == null || values.length == 0) {
            return defaultValue;
        }
        return values[0];
    }

    public static String[] getValues(SlingHttpServletRequest request, String name, String[] defaultValues) {
        ValueMap globalFormValues = FormsHelper.getGlobalFormValues(request);
        if (globalFormValues == null || globalFormValues.get((Object)name) == null) {
            return defaultValues;
        }
        return (String[])globalFormValues.get(name, String[].class);
    }

    public static void inlineValuesAsJson(SlingHttpServletRequest request, Writer out, String path) throws IOException, RepositoryException, JSONException {
        FormsHelper.inlineValuesAsJson(request, out, path, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void inlineValuesAsJson(SlingHttpServletRequest request, Writer out, String path, int nodeDepth) throws IOException, RepositoryException, JSONException {
        Node node;
        out.flush();
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        if (path.startsWith("/")) {
            if (!session.nodeExists(path)) {
                out.append("{}");
                return;
            }
            node = session.getNode(path);
        } else {
            Resource loadResource = FormsHelper.getFormLoadResource(request);
            if (loadResource == null) {
                out.append("{}");
                return;
            }
            node = (Node)loadResource.adaptTo(Node.class);
            if (node == null) {
                out.append("{}");
                return;
            }
            if (!node.hasNode(path)) {
                out.append("{}");
                return;
            }
            node = node.getNode(path);
        }
        JsonItemWriter jsonWriter = new JsonItemWriter(null);
        jsonWriter.dump(node, (Writer)new PrintWriter(out), nodeDepth);
        out.flush();
    }

    private static void accumulateShowHideExpressions(Node node, Map<String, String> map) throws RepositoryException {
        if (node.hasProperty("showHideExpression")) {
            map.put(node.hasProperty("name") ? node.getProperty("name").getString() : node.getName(), node.getProperty("showHideExpression").getString());
        }
        NodeIterator iterator = node.getNodes();
        while (iterator.hasNext()) {
            FormsHelper.accumulateShowHideExpressions(iterator.nextNode(), map);
        }
    }

    public static Map<String, String> getShowHideExpressions(Resource resource) throws RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        HashMap<String, String> map = new HashMap<String, String>();
        FormsHelper.accumulateShowHideExpressions(node, map);
        return map;
    }

    public static Map<String, String> getOptions(SlingHttpServletRequest request, Resource elementResource) {
        Resource rsrc;
        ValueMap properties = ResourceUtil.getValueMap((Resource)elementResource);
        String[] options = null;
        String loadPath = (String)properties.get("optionsLoadPath", (Object)"");
        if (loadPath.length() > 0 && (rsrc = request.getResourceResolver().getResource(loadPath)) != null) {
            options = (String[])rsrc.adaptTo(String[].class);
        }
        if (options == null) {
            options = (String[])properties.get("options", String[].class);
        }
        if (options == null) {
            return null;
        }
        LinkedHashMap<String, String> splitValues = new LinkedHashMap<String, String>();
        for (int i = 0; i < options.length; ++i) {
            String value = options[i].trim();
            if (value.length() > 0) {
                String t;
                String v;
                boolean endLoop = true;
                int pos = -1;
                int start = 0;
                do {
                    if ((pos = value.indexOf(61, start)) > 0 && value.charAt(pos - 1) == '\\') {
                        start = pos + 1;
                        endLoop = false;
                        continue;
                    }
                    endLoop = true;
                } while (!endLoop);
                if (pos == -1) {
                    v = value;
                    t = value;
                } else {
                    v = value.substring(0, pos);
                    t = value.substring(pos + 1);
                }
                v = v.replace("\\=", "=");
                t = t.replace("\\=", "=");
                splitValues.put(v, t);
                continue;
            }
            splitValues.put("", "");
        }
        if (splitValues.size() == 0) {
            return null;
        }
        return splitValues;
    }

    public static boolean isRequired(Resource formElement) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (Boolean)properties.get("required", (Object)Boolean.FALSE);
    }

    public static void setFormReadOnly(SlingHttpServletRequest request) {
        request.setAttribute(REQ_ATTR_READ_ONLY, (Object)true);
    }

    public static boolean isReadOnly(SlingHttpServletRequest request, Resource formElement) {
        if (request.getAttribute(REQ_ATTR_READ_ONLY) != null) {
            return true;
        }
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (Boolean)properties.get("readOnly", (Object)Boolean.FALSE);
    }

    public static boolean isReadOnly(SlingHttpServletRequest request) {
        return request.getAttribute(REQ_ATTR_READ_ONLY) != null;
    }

    @Deprecated
    public static boolean isReadOnly(Resource formElement) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (Boolean)properties.get("readOnly", (Object)Boolean.FALSE);
    }

    public static boolean checkRule(Resource resource, SlingHttpServletRequest req, PageContext pageContext, String propName) {
        ValueMap valueMap = ResourceUtil.getValueMap((Resource)resource);
        String rule = (String)valueMap.get(propName, (Object)null);
        if (rule == null) {
            return true;
        }
        String[] ruleParts = (rule = ELEvaluator.evaluate(rule, req, pageContext)).split(":");
        if (ruleParts.length < 2) {
            return true;
        }
        if (ruleParts[0].equals("access")) {
            if (ruleParts.length != 3) {
                return true;
            }
            String path = ruleParts[1];
            String permission = ruleParts[2];
            try {
                Node node = (Node)resource.adaptTo(Node.class);
                Session session = node.getSession();
                session.checkPermission(path, permission);
            }
            catch (AccessControlException ace) {
                return false;
            }
            catch (RepositoryException re) {
                LOGGER.error("Could not determine access rights for path '" + path + "'", (Throwable)re);
                return false;
            }
        }
        return true;
    }

    public static String getTitle(Resource formElement, String defaultTitle) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (String)properties.get("jcr:title", (Object)defaultTitle);
    }

    public static String getDescription(Resource formElement, String defaultDescription) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (String)properties.get("jcr:description", (Object)defaultDescription);
    }

    public static boolean hasMultiSelection(Resource formElement) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (Boolean)properties.get("multiSelection", (Object)Boolean.FALSE);
    }

    public static void redirectToReferrer(SlingHttpServletRequest req, SlingHttpServletResponse res, Map<String, String[]> params) throws IOException {
        String referrer = FormsHelper.getReferrer((HttpServletRequest)req);
        if (params != null && params.size() > 0) {
            StringBuilder buffer = new StringBuilder(referrer);
            boolean hasParams = referrer.indexOf(63) > 0;
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                for (String value : entry.getValue()) {
                    buffer.append(hasParams ? (char)'&' : '?');
                    hasParams = true;
                    buffer.append(entry.getKey());
                    buffer.append('=');
                    buffer.append(URLEncoder.encode(value, "utf-8"));
                }
            }
            res.sendRedirect(buffer.toString());
        } else {
            res.sendRedirect(referrer);
        }
    }

    public static void redirectToReferrer(SlingHttpServletRequest request, SlingHttpServletResponse res) throws IOException {
        String referrer = FormsHelper.getReferrer((HttpServletRequest)request);
        int pos = referrer.indexOf(63);
        if (pos > 0) {
            referrer = referrer.substring(0, pos);
        }
        StringBuilder buffer = new StringBuilder(referrer);
        RequestParameterMap params = request.getRequestParameterMap();
        if (params.entrySet().size() > 0) {
            buffer.append("?");
            boolean first = true;
            for (Map.Entry current : params.entrySet()) {
                RequestParameter[] values = (RequestParameter[])current.getValue();
                for (int i = 0; i < values.length; ++i) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append("&");
                    }
                    buffer.append((String)current.getKey());
                    buffer.append("=");
                    buffer.append(values[i].getString());
                }
            }
        }
        res.sendRedirect(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource checkFormStructure(Resource rsrc) {
        Resource formStart;
        if (FormsHelper.checkResourceType(rsrc, "foundation/components/form/start")) {
            Node start = (Node)rsrc.adaptTo(Node.class);
            if (start != null) {
                try {
                    if (!start.hasProperty("actionType")) {
                        start.setProperty("actionType", "foundation/components/form/actions/store");
                        String defaultContentPath = "/content/usergenerated" + rsrc.getPath().replaceAll("^.content", "").replaceAll("jcr.content.*", "") + "cq-gen" + System.currentTimeMillis() + "/";
                        start.setProperty("action", defaultContentPath);
                    }
                    if (!start.hasProperty("formid")) {
                        start.setProperty("formid", rsrc.getPath().replaceAll("[/:.]", "_"));
                    }
                    start.getSession().save();
                }
                catch (RepositoryException e) {
                    LOGGER.error("Unable to add default action type and form id " + rsrc, (Throwable)e);
                }
            } else {
                LOGGER.error("Resource is not adaptable to node - unable to add default action type and form id for " + rsrc);
            }
            Iterator iter = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)rsrc));
            while (!((Resource)iter.next()).getPath().equals(rsrc.getPath())) {
            }
            Resource formEnd = null;
            Resource nextPar = null;
            boolean stop = false;
            while (iter.hasNext() && formEnd == null && !stop) {
                Resource current = (Resource)iter.next();
                if (nextPar == null) {
                    nextPar = current;
                }
                if (FormsHelper.checkResourceType(current, "foundation/components/form/end")) {
                    formEnd = current;
                    continue;
                }
                if (!FormsHelper.checkResourceType(current, "foundation/components/form/start")) continue;
                stop = true;
            }
            if (formEnd == null) {
                Node parent = (Node)ResourceUtil.getParent((Resource)rsrc).adaptTo(Node.class);
                if (parent != null) {
                    try {
                        String nodeName = "form_end_" + System.currentTimeMillis();
                        Node node = parent.addNode(nodeName);
                        ValueMap props = ResourceUtil.getValueMap((Resource)rsrc);
                        String resourceType = "foundation/components/form/end";
                        if (props != null) {
                            resourceType = (String)props.get("endResourceType", (Object)resourceType);
                        }
                        node.setProperty("sling:resourceType", resourceType);
                        if (!resourceType.equals("foundation/components/form/end")) {
                            node.setProperty("sling:resourceSuperType", "foundation/components/form/end");
                        }
                        if (nextPar != null) {
                            parent.orderBefore(node.getName(), ResourceUtil.getName((Resource)nextPar));
                        }
                        parent.getSession().save();
                        Iterator i = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)rsrc));
                        while (true) {
                            if (!i.hasNext()) break;
                            Resource r = (Resource)i.next();
                            if (!nodeName.equals(ResourceUtil.getName((Resource)r))) continue;
                            Resource resource = r;
                            return resource;
                        }
                    }
                    catch (RepositoryException re) {
                        LOGGER.error("Unable to create missing form end element for form start " + rsrc, (Throwable)re);
                    }
                    finally {
                        try {
                            if (parent.getSession().hasPendingChanges()) {
                                parent.getSession().refresh(false);
                            }
                        }
                        catch (RepositoryException re) {}
                    }
                } else {
                    LOGGER.error("Resource is not adaptable to node - unable to add missing form end element for " + rsrc);
                }
            }
        } else if (FormsHelper.checkResourceType(rsrc, "foundation/components/form/end") && (formStart = FormsHelper.searchFormStart(rsrc)) == null) {
            Node node = (Node)rsrc.adaptTo(Node.class);
            Node parent = (Node)ResourceUtil.getParent((Resource)rsrc).adaptTo(Node.class);
            if (node != null && parent != null) {
                try {
                    node.remove();
                    parent.getSession().save();
                    Resource nextPar = rsrc;
                    return nextPar;
                }
                catch (RepositoryException re) {
                    LOGGER.error("Unable to create missing form end element for form start " + rsrc, (Throwable)re);
                }
                finally {
                    try {
                        if (node.getSession().hasPendingChanges()) {
                            node.getSession().refresh(false);
                        }
                    }
                    catch (RepositoryException re) {}
                }
            }
            LOGGER.error("Resource is not adaptable to node - unable to remove form element " + rsrc);
        }
        return null;
    }

    public static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static String decodeValue(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static String getCss(ValueMap props, String defaultCss) {
        String configCss = (String)props.get("css", null);
        if (configCss == null) {
            return defaultCss;
        }
        return defaultCss + ' ' + StringEscapeUtils.escapeHtml4((String)configCss);
    }

    public static String getReferrer(HttpServletRequest request) {
        return request.getHeader("Referer") != null ? request.getHeader("Referer") : request.getHeader("Referrer");
    }

    public static void setRedirectToReferrer(ServletRequest request, boolean redirectToReferrer) {
        if (redirectToReferrer) {
            request.setAttribute(REQ_ATTR_REDIRECT_TO_REFERRER, (Object)"true");
        } else {
            request.removeAttribute(REQ_ATTR_REDIRECT_TO_REFERRER);
        }
    }

    public static boolean isRedirectToReferrer(ServletRequest request) {
        return "true".equals(request.getAttribute(REQ_ATTR_REDIRECT_TO_REFERRER));
    }
}

