/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.impl;

import com.day.cq.wcm.workflow.api.WcmWorkflowService;
import com.day.cq.wcm.workflow.impl.AutoAssignRule;
import com.day.cq.wcm.workflow.impl.WorkflowAutoAssignAllocator;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowAutoAssignAllocatorServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -2493359347557572037L;
    private WorkflowService workflowService;
    private WcmWorkflowService wcmWorkflowService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        WorkflowSession wfSession = this.workflowService.getWorkflowSession(session);
        response.setContentType("application/json");
        WorkflowAutoAssignAllocator allocator = new WorkflowAutoAssignAllocator(wfSession, this.wcmWorkflowService.getWcmConfigPath() + "/templates");
        try {
            this.sendRules(response, allocator.getAllRules(), session);
        }
        catch (Exception e) {
            this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
        }
    }

    private void sendRules(SlingHttpServletResponse response, Map<String, List<AutoAssignRule>> allRules, Session session) throws IOException, JSONException, RepositoryException {
        if (allRules != null) {
            JSONWriter writer = new JSONWriter((Writer)response.getWriter());
            writer.object();
            writer.key("rules");
            writer.array();
            long nbrOfRules = 0L;
            for (String key : allRules.keySet()) {
                for (AutoAssignRule rule : allRules.get(key)) {
                    writer.object();
                    writer.key("globbing");
                    writer.value((Object)rule.getGlobbing());
                    writer.key("workflowModelTitle");
                    writer.value((Object)rule.getWorkflowModel().getTitle());
                    writer.key("workflowModelPath");
                    writer.value((Object)rule.getWorkflowModel().getId());
                    writer.key("templatePath");
                    writer.value((Object)rule.getTemplatePath());
                    writer.key("templateTitle");
                    try {
                        Item template = session.getItem(rule.getTemplatePath());
                        writer.value((Object)((Node)template).getProperty("jcr:title").getString());
                    }
                    catch (PathNotFoundException e) {
                        writer.value((Object)"");
                    }
                    writer.key("rulePath");
                    writer.value((Object)rule.getNode().getPath());
                    writer.endObject();
                    ++nbrOfRules;
                }
            }
            writer.endArray();
            writer.key("results").value(nbrOfRules);
            writer.endObject();
        } else {
            this.sendResponse((HttpServletResponse)response, 404, "Rules do not exist");
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        ResourceBundle resBundle = request.getResourceBundle(null);
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        RequestParameterMap params = request.getRequestParameterMap();
        WorkflowSession wfSession = this.workflowService.getWorkflowSession(session);
        WorkflowAutoAssignAllocator allocator = new WorkflowAutoAssignAllocator(wfSession, this.wcmWorkflowService.getWcmConfigPath() + "/templates");
        RequestParameter reqPara = null;
        reqPara = params.getValue("delete");
        if (reqPara != null) {
            try {
                allocator.removeRule(new AutoAssignRule((Node)wfSession.getSession().getItem(reqPara.getString()), wfSession));
                this.sendResponse((HttpServletResponse)response, 200, resBundle.getString("Rule deleted"));
            }
            catch (Exception e) {
                this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
            }
        } else {
            reqPara = params.getValue("add");
            if (reqPara != null && params.getValue("globbing") != null && params.getValue("modelId") != null) {
                String templatePath = reqPara.getString();
                String globbing = params.getValue("globbing").getString();
                String modelId = params.getValue("modelId").getString();
                try {
                    AutoAssignRule rule = allocator.addRule(templatePath, wfSession.getModel(modelId), globbing);
                    this.sendResourceCreatedResponse((HttpServletResponse)response, this.getUrl(request, rule.getNode().getPath()));
                }
                catch (Exception e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            } else {
                reqPara = params.getValue("edit");
                if (reqPara != null && params.getValue("globbing") != null && params.getValue("modelId") != null) {
                    String rulePath = reqPara.getString();
                    String globbing = params.getValue("globbing").getString();
                    String modelId = params.getValue("modelId").getString();
                    try {
                        AutoAssignRule rule = allocator.editRule(rulePath, wfSession.getModel(modelId), globbing);
                        this.sendResourceEditedResponse((HttpServletResponse)response, this.getUrl(request, rule.getNode().getPath()));
                    }
                    catch (Exception e) {
                        this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                    }
                } else {
                    this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
                }
            }
        }
    }

    private void sendResponse(HttpServletResponse response, int status, String message) {
        HtmlResponse htmlResponse = new HtmlResponse();
        htmlResponse.setStatus(status, message);
        htmlResponse.setTitle(message);
        try {
            htmlResponse.send(response, true);
        }
        catch (IOException e) {
            this.log("Error while writing response", e);
        }
    }

    private void sendResourceCreatedResponse(HttpServletResponse response, String url) {
        HtmlResponse htmlResponse = new HtmlResponse();
        htmlResponse.setStatus(201, "Created");
        htmlResponse.setTitle("Created");
        htmlResponse.setLocation(url);
        try {
            htmlResponse.send(response, true);
        }
        catch (IOException e) {
            this.log("Error while writing response", e);
        }
    }

    private void sendResourceEditedResponse(HttpServletResponse response, String url) {
        HtmlResponse htmlResponse = new HtmlResponse();
        htmlResponse.setStatus(200, "Edited");
        htmlResponse.setTitle("Edited");
        htmlResponse.setLocation(url);
        try {
            htmlResponse.send(response, true);
        }
        catch (IOException e) {
            this.log("Error while writing response", e);
        }
    }

    private String getUrl(SlingHttpServletRequest request, String uri) {
        return "http://" + request.getLocalName() + ":" + request.getLocalPort() + request.getContextPath() + uri;
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }

    protected void bindWcmWorkflowService(WcmWorkflowService wcmWorkflowService) {
        this.wcmWorkflowService = wcmWorkflowService;
    }

    protected void unbindWcmWorkflowService(WcmWorkflowService wcmWorkflowService) {
        if (this.wcmWorkflowService == wcmWorkflowService) {
            this.wcmWorkflowService = null;
        }
    }
}

