/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.impl;

import com.day.cq.security.Authorizable;
import com.day.cq.security.Group;
import com.day.cq.security.UserManager;
import com.day.cq.security.UserManagerFactory;
import com.day.cq.wcm.api.PageInfoProvider;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.filter.WorkItemFilter;
import com.day.cq.workflow.model.WorkflowModel;
import com.day.cq.workflow.model.WorkflowNode;
import com.day.cq.workflow.status.WorkflowStatus;
import com.day.cq.xss.ProtectionContext;
import com.day.cq.xss.XSSProtectionException;
import com.day.cq.xss.XSSProtectionService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowStatusProvider
implements PageInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(WorkflowStatusProvider.class);
    private SlingRepository repository;
    private UserManagerFactory userManagerFactory;
    private XSSProtectionService xss;
    private UserManager userManager;
    private Session admin;

    public void updatePageInfo(SlingHttpServletRequest request, JSONObject info, Resource resource) throws JSONException {
        JSONObject workflow = new JSONObject();
        WorkflowStatus wfState = (WorkflowStatus)resource.adaptTo(WorkflowStatus.class);
        if (wfState != null) {
            WorkflowModel wfModel;
            Workflow wf;
            workflow.put("isRunning", wfState.isInRunningWorkflow(true));
            List wfList = wfState.getWorkflows(true);
            Workflow workflow2 = wf = wfList.size() > 0 ? (Workflow)wfList.get(0) : null;
            if (wf != null && null != (wfModel = wf.getWorkflowModel())) {
                workflow.put("id", (Object)wf.getId());
                workflow.put("state", (Object)wf.getState());
                workflow.put("model", (Object)new JSONObject().put("title", (Object)wfModel.getTitle()));
                String workflowTitle = (String)wf.getWorkflowData().getMetaDataMap().get("workflowTitle", String.class);
                if (workflowTitle != null) {
                    workflow.put("title", (Object)workflowTitle);
                }
                JSONArray workitems = new JSONArray();
                if (wf.getWorkItems().size() > 0) {
                    Session userSession = (Session)request.getResourceResolver().adaptTo(Session.class);
                    List items = wf.getWorkItems((WorkItemFilter)new UserFilter(userSession, this.userManager));
                    for (WorkItem wi : items) {
                        WorkflowNode wn = wi.getNode();
                        if (!wn.getType().equals("PARTICIPANT") && !wn.getType().equals("DYNAMIC_PARTICIPANT")) continue;
                        JSONObject obj = new JSONObject();
                        obj.put("id", (Object)wi.getId());
                        obj.put("title", (Object)wn.getTitle());
                        if (this.xss != null) {
                            try {
                                obj.put("title_xss", (Object)this.xss.protectForContext(ProtectionContext.PLAIN_HTML_CONTENT, wn.getTitle()));
                            }
                            catch (XSSProtectionException e) {
                                log.warn("Unable to write protected value for workflow node title {}", (Object)wn.getTitle());
                            }
                        }
                        obj.put("description", (Object)wn.getDescription());
                        if (this.xss != null) {
                            try {
                                obj.put("description_xss", (Object)this.xss.protectForContext(ProtectionContext.PLAIN_HTML_CONTENT, wn.getDescription()));
                            }
                            catch (XSSProtectionException e) {
                                log.warn("Unable to write protected value for workflow node description {}", (Object)wn.getDescription());
                            }
                        }
                        obj.put("startTime", wi.getTimeStarted().getTime());
                        String comment = (String)wn.getMetaDataMap().get("comment", String.class);
                        obj.put("comment", (Object)(null == comment ? "" : comment));
                        workitems.put((Object)obj);
                    }
                }
                workflow.put("workitems", (Object)workitems);
            }
        }
        info.put("workflowInfo", (Object)workflow);
    }

    protected void activate(ComponentContext context) throws WorkflowException, RepositoryException {
        this.admin = this.repository.loginAdministrative(null);
        this.userManager = this.userManagerFactory.createUserManager(this.admin);
    }

    protected void deactivate(ComponentContext context) {
        if (this.admin != null) {
            this.admin.logout();
            this.admin = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindUserManagerFactory(UserManagerFactory userManagerFactory) {
        this.userManagerFactory = userManagerFactory;
    }

    protected void unbindUserManagerFactory(UserManagerFactory userManagerFactory) {
        if (this.userManagerFactory == userManagerFactory) {
            this.userManagerFactory = null;
        }
    }

    protected void bindXss(XSSProtectionService xSSProtectionService) {
        this.xss = xSSProtectionService;
    }

    protected void unbindXss(XSSProtectionService xSSProtectionService) {
        if (this.xss == xSSProtectionService) {
            this.xss = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UserFilter
    implements WorkItemFilter {
        private Session session;
        private UserManager userManager;
        private List<Authorizable> authList = null;

        public UserFilter(Session session, UserManager userManager) {
            this.session = session;
            this.userManager = userManager;
        }

        public boolean doInclude(WorkItem workItem) {
            String assignee = workItem.getCurrentAssignee();
            for (Authorizable auth : this.getAuthorizables()) {
                if (!assignee.equals(auth.getID())) continue;
                return true;
            }
            return false;
        }

        private List<Authorizable> getAuthorizables() {
            if (this.authList == null) {
                ArrayList<Authorizable> auths = new ArrayList<Authorizable>();
                Authorizable user = this.userManager.get(this.session.getUserID());
                auths.add(user);
                this.getGroups(user, auths);
                this.authList = auths;
            }
            return this.authList;
        }

        private void getGroups(Authorizable authorizable, List<Authorizable> auths) {
            Iterator groups = this.userManager.get(authorizable.getID()).memberOf();
            while (groups.hasNext()) {
                Group group = (Group)groups.next();
                auths.add((Authorizable)group);
                this.getGroups((Authorizable)group, auths);
            }
        }
    }
}

