/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.process;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.workflow.api.WcmWorkflowService;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.collection.ResourceCollection;
import com.day.cq.workflow.collection.ResourceCollectionManager;
import com.day.cq.workflow.collection.ResourceCollectionUtil;
import com.day.cq.workflow.exec.HistoryItem;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplicatePageProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ReplicatePageProcess.class);
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    public static final String TYPE_JCR_UUID = "JCR_UUID";
    protected Replicator replicator;
    protected WcmWorkflowService wcmWfService;
    protected WorkflowService wfService;
    protected EventAdmin eventAdmin;
    protected ResourceCollectionManager rcManager;
    private SlingRepository repository;
    private Session admin;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        Session participantSession = null;
        Session replicationSession = null;
        try {
            String approverId;
            Session session = workflowSession.getSession();
            if (this.replicateAsParticipant(args) && (approverId = this.resolveParticipantId(workItem, workflowSession)) != null) {
                participantSession = this.getParticipantSession(approverId, workflowSession);
            }
            replicationSession = participantSession != null ? participantSession : session;
            WorkflowData data = workItem.getWorkflowData();
            String path = null;
            String type = data.getPayloadType();
            if (type.equals(TYPE_JCR_PATH) && data.getPayload() != null) {
                String payloadData = (String)data.getPayload();
                if (session.itemExists(payloadData)) {
                    path = payloadData;
                }
            } else if (data.getPayload() != null && type.equals(TYPE_JCR_UUID)) {
                Node node = session.getNodeByUUID((String)data.getPayload());
                path = node.getPath();
            }
            ReplicationOptions opts = null;
            String rev = (String)data.getMetaDataMap().get("resourceVersion", String.class);
            if (rev != null) {
                opts = new ReplicationOptions();
                opts.setRevision(rev);
            }
            opts = this.prepareOptions(opts);
            if (path != null) {
                ResourceCollection rcCollection = ResourceCollectionUtil.getResourceCollection((Node)((Node)this.admin.getItem(path)), (ResourceCollectionManager)this.rcManager);
                List<String> paths = this.getPaths(path, rcCollection);
                for (String aPath : paths) {
                    if (this.canReplicate(replicationSession, aPath)) {
                        if (opts != null) {
                            this.replicator.replicate(replicationSession, this.getReplicationType(), aPath, opts);
                            continue;
                        }
                        this.replicator.replicate(replicationSession, this.getReplicationType(), aPath);
                        continue;
                    }
                    log.debug(session.getUserID() + " is not allowed to replicate " + "this page/asset " + aPath + ". Issuing request for 'replication");
                    Hashtable<String, String> properties = new Hashtable<String, String>();
                    ((Dictionary)properties).put("path", aPath);
                    ((Dictionary)properties).put("replicationType", (String)this.getReplicationType());
                    ((Dictionary)properties).put("userId", session.getUserID());
                    Event event = new Event("com/day/cq/wcm/workflow/req/for/activation", properties);
                    this.eventAdmin.sendEvent(event);
                }
            } else {
                log.warn("Cannot activate page or asset because path is null for this workitem: " + workItem.toString());
            }
        }
        catch (RepositoryException e) {
            throw new WorkflowException((Throwable)e);
        }
        catch (ReplicationException e) {
            throw new WorkflowException((Throwable)e);
        }
        finally {
            if (participantSession != null && participantSession.isLive()) {
                participantSession.logout();
                participantSession = null;
            }
        }
    }

    private boolean replicateAsParticipant(MetaDataMap args) {
        String processArgs = (String)args.get(Arguments.PROCESS_ARGS.getArgumentName(), String.class);
        if (processArgs != null && !processArgs.equals("")) {
            String[] arguments;
            for (String argument : arguments = processArgs.split(",")) {
                String[] split = argument.split("=");
                if (split.length != 2) continue;
                String key = split[0];
                String value = split[1];
                if (!key.equalsIgnoreCase(Arguments.REPLICATE_AS_PARTICIPANT.getArgumentName())) continue;
                return Boolean.parseBoolean(value);
            }
            return false;
        }
        return (Boolean)args.get(Arguments.REPLICATE_AS_PARTICIPANT.getArgumentName(), (Object)Boolean.FALSE);
    }

    private Session getParticipantSession(String participantId, WorkflowSession workflowSession) {
        try {
            return workflowSession.getSession().impersonate((Credentials)new SimpleCredentials(participantId, new char[0]));
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    private String resolveParticipantId(WorkItem workItem, WorkflowSession workflowSession) {
        List history = new ArrayList();
        try {
            history = workflowSession.getHistory(workItem.getWorkflow());
            for (int index = history.size() - 1; index >= 0; --index) {
                HistoryItem previous = (HistoryItem)history.get(index);
                String type = previous.getWorkItem().getNode().getType();
                if (type == null || !type.equals("PARTICIPANT") && !type.equals("DYNAMIC_PARTICIPANT")) continue;
                return previous.getUserId();
            }
            return null;
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    private List<String> getPaths(String path, ResourceCollection rcCollection) {
        ArrayList<String> paths = new ArrayList<String>();
        if (rcCollection == null) {
            paths.add(path);
        } else {
            log.debug("ResourceCollection detected " + rcCollection.getPath());
            try {
                List members = rcCollection.list(new String[]{"cq:Page", "dam:Asset"});
                for (Node member : members) {
                    String mPath = member.getPath();
                    paths.add(mPath);
                }
            }
            catch (RepositoryException re) {
                log.error("Cannot build path list out of the resource collection " + rcCollection.getPath());
            }
        }
        return paths;
    }

    public abstract ReplicationActionType getReplicationType();

    protected ReplicationOptions prepareOptions(ReplicationOptions opts) {
        return opts;
    }

    protected boolean canReplicate(Session session, String path) throws AccessDeniedException {
        try {
            AccessControlManager acMgr = session.getAccessControlManager();
            return acMgr.hasPrivileges(path, new Privilege[]{acMgr.privilegeFromName("{http://www.day.com/crx/1.0}replicate")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        this.admin = this.repository.loginAdministrative(null);
    }

    protected void deactivate(ComponentContext context) {
        if (this.admin != null) {
            this.admin.logout();
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindWcmWfService(WcmWorkflowService wcmWorkflowService) {
        this.wcmWfService = wcmWorkflowService;
    }

    protected void unbindWcmWfService(WcmWorkflowService wcmWorkflowService) {
        if (this.wcmWfService == wcmWorkflowService) {
            this.wcmWfService = null;
        }
    }

    protected void bindWfService(WorkflowService workflowService) {
        this.wfService = workflowService;
    }

    protected void unbindWfService(WorkflowService workflowService) {
        if (this.wfService == workflowService) {
            this.wfService = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindRcManager(ResourceCollectionManager resourceCollectionManager) {
        this.rcManager = resourceCollectionManager;
    }

    protected void unbindRcManager(ResourceCollectionManager resourceCollectionManager) {
        if (this.rcManager == resourceCollectionManager) {
            this.rcManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        REPLICATE_AS_PARTICIPANT("replicateAsParticipant");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }
    }
}

