/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageInfoProvider;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.workflow.PayloadMap;
import com.day.cq.workflow.collection.ResourceCollection;
import com.day.cq.workflow.collection.ResourceCollectionManager;
import com.day.jcr.vault.fs.api.Filter;
import com.day.jcr.vault.fs.api.PathFilter;
import com.day.jcr.vault.fs.api.PathFilterSet;
import com.day.jcr.vault.fs.config.DefaultWorkspaceFilter;
import com.day.jcr.vault.fs.filter.DefaultPathFilter;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%workflowpackageinfoprovider.name", description="%workflowpackageinfoprovider.description")
@Service
public class WorkflowPackageInfoProvider
implements PageInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(WorkflowPackageInfoProvider.class);
    @Reference(policy=ReferencePolicy.STATIC)
    private SlingRepository repository;
    @Reference(policy=ReferencePolicy.STATIC)
    private ResourceCollectionManager resourceCollectionManager;
    @Reference(policy=ReferencePolicy.STATIC)
    private PayloadMap payloadMap;
    @Property(value={}, unbounded=PropertyUnbounded.ARRAY)
    private static final String SCR_PROP_NAME_FILTER = "workflowpackageinfoprovider.filter";
    private DefaultWorkspaceFilter filter;

    public void updatePageInfo(SlingHttpServletRequest request, JSONObject info, Resource resource) throws JSONException {
        JSONObject workflowPackage = new JSONObject();
        ResourceResolver resourceResolver = resource.getResourceResolver();
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        JSONArray selectedWorkflowPackages = new JSONArray();
        JSONArray runningSelectedWorkflowPackages = new JSONArray();
        List wpList = this.resourceCollectionManager.getCollections((Session)resourceResolver.adaptTo(Session.class));
        JSONArray wpArray = new JSONArray();
        if (wpList != null) {
            int i = 0;
            for (ResourceCollection wp : wpList) {
                String wpPath = wp.getPath();
                if (!this.filter.contains(wpPath)) continue;
                try {
                    Page wpPage = pageManager.getPage(wpPath);
                    List instances = this.payloadMap.getWorkflowInstances(wpPath, false);
                    boolean isInCurrentWorkflowPackage = false;
                    for (Node wpContentNode : wp.list(new String[]{"cq:Page"})) {
                        if (!wpContentNode.getPath().equals(resource.getPath())) continue;
                        isInCurrentWorkflowPackage = true;
                        break;
                    }
                    JSONObject obj = new JSONObject();
                    obj.put("path", (Object)wpPath);
                    obj.put("title", (Object)wpPage.getTitle());
                    obj.put("isInWorkflowPackage", isInCurrentWorkflowPackage);
                    boolean isRunning = instances.size() > 0;
                    obj.put("isRunning", isRunning);
                    wpArray.put((Object)obj);
                    if (isInCurrentWorkflowPackage) {
                        selectedWorkflowPackages.put(i);
                        if (isRunning) {
                            runningSelectedWorkflowPackages.put(i);
                        }
                    }
                    ++i;
                }
                catch (RepositoryException e) {
                    log.warn("Unable to get information for workflow package [{}]", (Object)wpPath, (Object)e);
                }
            }
        }
        workflowPackage.put("workflowPackages", (Object)wpArray);
        workflowPackage.put("selectedWorkflowPackages", (Object)selectedWorkflowPackages);
        workflowPackage.put("runningSelectedWorkflowPackages", (Object)runningSelectedWorkflowPackages);
        info.put("workflowPackageInfo", (Object)workflowPackage);
    }

    protected void activate(ComponentContext context) {
        this.filter = new DefaultWorkspaceFilter();
        PathFilterSet set = new PathFilterSet("/etc/workflow/packages");
        set.addInclude((Filter)PathFilter.ALL);
        Object filterProp = context.getProperties().get(SCR_PROP_NAME_FILTER);
        if (filterProp != null) {
            String[] filterPaths;
            for (String filterPath : filterPaths = OsgiUtil.toStringArray(filterProp)) {
                if (filterPath.startsWith("-")) {
                    set.addExclude((Filter)new DefaultPathFilter(filterPath.substring(1)));
                    continue;
                }
                if (filterPath.startsWith("+")) {
                    filterPath = filterPath.substring(1);
                }
                set.addInclude((Filter)new DefaultPathFilter(filterPath));
            }
        }
        this.filter.add(set);
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResourceCollectionManager(ResourceCollectionManager resourceCollectionManager) {
        this.resourceCollectionManager = resourceCollectionManager;
    }

    protected void unbindResourceCollectionManager(ResourceCollectionManager resourceCollectionManager) {
        if (this.resourceCollectionManager == resourceCollectionManager) {
            this.resourceCollectionManager = null;
        }
    }

    protected void bindPayloadMap(PayloadMap payloadMap) {
        this.payloadMap = payloadMap;
    }

    protected void unbindPayloadMap(PayloadMap payloadMap) {
        if (this.payloadMap == payloadMap) {
            this.payloadMap = null;
        }
    }
}

