/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.metadata;

import com.day.cq.workflow.metadata.MetaDataMap;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMetaDataMap
extends HashMap<String, Object>
implements MetaDataMap {
    private static final long serialVersionUID = 1360764073724170383L;

    @Override
    public <T> T get(String name, Class<T> type) {
        return this.convert(this.get(name), type);
    }

    @Override
    public <T> T get(String name, T defaultValue) {
        if (defaultValue == null) {
            return (T)this.get(name);
        }
        Class<?> value = this.get(name, (T)defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }

    private <T> T convert(Object obj, Class<T> type) {
        try {
            if (obj == null) {
                return null;
            }
            if (type.isAssignableFrom(obj.getClass())) {
                return (T)obj;
            }
            if (type.isArray()) {
                return (T)this.convertToArray(obj, type.getComponentType());
            }
            if (type == String.class) {
                return (T)String.valueOf(obj);
            }
            if (type == Integer.class) {
                return (T)Integer.valueOf(Integer.parseInt(obj.toString()));
            }
            if (type == Long.class) {
                return (T)Long.valueOf(Long.parseLong(obj.toString()));
            }
            if (type == Double.class) {
                return (T)Double.valueOf(Double.parseDouble(obj.toString()));
            }
            if (type == Boolean.class) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(obj.toString()));
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private <T> T[] convertToArray(Object obj, Class<T> type) {
        LinkedList<T> values = new LinkedList<T>();
        if (obj.getClass().isArray()) {
            for (Object o : (Object[])obj) {
                values.add(this.convert(o, type));
            }
        } else {
            values.add(this.convert(obj, type));
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }
}

