/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.launcher.impl;

import com.day.cq.workflow.launcher.ConfigEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LauncherConfig {
    private Map<Integer, Map<String, List<ConfigEntry>>> eventTypeMap = new HashMap<Integer, Map<String, List<ConfigEntry>>>();

    public void add(ConfigEntry entry) {
        Map<String, List<ConfigEntry>> nodetypeMap;
        if (!this.eventTypeMap.containsKey(entry.getEventType())) {
            this.eventTypeMap.put(entry.getEventType(), new HashMap());
        }
        if (!(nodetypeMap = this.eventTypeMap.get(entry.getEventType())).containsKey(entry.getNodetype())) {
            nodetypeMap.put(entry.getNodetype(), new ArrayList());
        }
        this.add(nodetypeMap.get(entry.getNodetype()), entry);
    }

    private void add(List<ConfigEntry> configEntries, ConfigEntry entry) {
        LinkedList<ConfigEntry> newList = new LinkedList<ConfigEntry>();
        newList.add(entry);
        for (ConfigEntry configEntry : configEntries) {
            int count = 0;
            boolean added = false;
            for (ConfigEntry ce : newList) {
                String globToInsert = configEntry.getGlob();
                String glob = ce.getGlob();
                if (globToInsert.length() >= glob.length()) {
                    newList.add(count, configEntry);
                    added = true;
                    break;
                }
                ++count;
            }
            if (added) continue;
            newList.add(configEntry);
        }
        configEntries.clear();
        configEntries.addAll(newList);
    }

    public void remove(ConfigEntry entry) {
        Map<String, List<ConfigEntry>> nodetypeMap;
        if (this.eventTypeMap.containsKey(entry.getEventType()) && (nodetypeMap = this.eventTypeMap.get(entry.getEventType())).containsKey(entry.getNodetype())) {
            List<ConfigEntry> list = nodetypeMap.get(entry.getNodetype());
        }
    }

    public Map<String, List<ConfigEntry>> get(int type) {
        if (this.eventTypeMap.containsKey(type)) {
            return this.eventTypeMap.get(type);
        }
        return new HashMap<String, List<ConfigEntry>>();
    }

    public Map<Integer, Map<String, List<ConfigEntry>>> getConfig() {
        return this.eventTypeMap;
    }

    public String toString() {
        String str = "";
        for (Integer eventType : this.eventTypeMap.keySet()) {
            str = str + "Event: " + eventType + "\n";
            Map<String, List<ConfigEntry>> eMap = this.eventTypeMap.get(eventType);
            for (String nt : eMap.keySet()) {
                str = str + "    NodeType: " + nt + "\n";
                List<ConfigEntry> list = eMap.get(nt);
                for (ConfigEntry entry : list) {
                    str = str + "        GlobPattern: " + entry.getGlob() + "\n";
                }
            }
        }
        return str;
    }
}

