/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.launcher.impl;

import com.day.cq.commons.jcr.ObservationUtil;
import com.day.cq.workflow.PayloadMap;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.launcher.ConfigEntry;
import com.day.cq.workflow.launcher.WorkflowLauncher;
import com.day.cq.workflow.launcher.impl.LauncherConfig;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.launchpad.api.StartupListener;
import org.apache.sling.launchpad.api.StartupMode;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowLauncherImpl
implements WorkflowLauncher,
EventListener,
Runnable,
StartupListener {
    private static final Logger log = LoggerFactory.getLogger(WorkflowLauncherImpl.class);
    private boolean startupFinished;
    public static final String SYSTEM_WORKFLOW_MODELS = "cq.workflow.launcher.map.execute.always";
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    static final Map<String, Pattern> excludePathsPattern = new HashMap<String, Pattern>(){
        {
            this.put("/var/audit(/.*)", Pattern.compile("/var/audit(/.*)"));
            this.put("/var/classes(/.*)", Pattern.compile("/var/classes(/.*)"));
            this.put("/var/eventing(/.*)", Pattern.compile("/var/eventing(/.*)"));
            this.put("/var/linkchecker(/.*)", Pattern.compile("/var/linkchecker(/.*)"));
            this.put("/var/statistics(?!/tracking)(/.*)", Pattern.compile("/var/statistics(?!/tracking)(/.*)"));
            this.put("/var/mobile(/.*)", Pattern.compile("/var/mobile(/.*)"));
            this.put("/tmp(/.*)", Pattern.compile("/tmp(/.*)"));
            this.put("/etc/workflow/instances(/.*)", Pattern.compile("/etc/workflow/instances(/.*)"));
        }
    };
    private static final String LAUNCHER_CONFIG_ROOT = "/etc/workflow/launcher/config";
    private SlingRepository repository;
    private WorkflowService workflowService;
    private PayloadMap payloadMap;
    private SlingSettingsService settingsService;
    private WorkflowSession wfSession;
    private WorkflowSession threadWorkflowSession;
    private LauncherConfig config;
    private Session adminSession;
    private Session threadAdminSession;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected final BlockingQueue<Map<String, Hit>> queue = new LinkedBlockingQueue<Map<String, Hit>>();
    protected volatile boolean running = false;
    Map<String, String> executeAllwaysWorkflowModelsMap = new HashMap<String, String>();

    public WorkflowLauncherImpl() {
    }

    public WorkflowLauncherImpl(WorkflowService workflowService, SlingRepository repository, SlingSettingsService settingsService, PayloadMap payloadMap, Dictionary<String, Object> props) throws RepositoryException {
        this.workflowService = workflowService;
        this.repository = repository;
        this.settingsService = settingsService;
        this.payloadMap = payloadMap;
        this.start(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigEntry(ConfigEntry entry) throws RepositoryException {
        this.lock.writeLock().lock();
        try {
            Node confRoot = (Node)this.adminSession.getItem(LAUNCHER_CONFIG_ROOT);
            Node entryNode = confRoot.addNode(String.valueOf(entry.hashCode()), "cq:WorkflowLauncher");
            this.setEntry(entryNode, entry);
            confRoot.save();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigEntry(String id) throws RepositoryException {
        this.lock.writeLock().lock();
        try {
            Node entry = (Node)this.adminSession.getItem(id);
            Node parent = entry.getParent();
            entry.remove();
            parent.save();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConfigEntry> getConfigEntries() {
        ArrayList<ConfigEntry> list = new ArrayList<ConfigEntry>();
        this.lock.readLock().lock();
        try {
            Map<Integer, Map<String, List<ConfigEntry>>> conf = this.config.getConfig();
            for (Map<String, List<ConfigEntry>> types : conf.values()) {
                for (List<ConfigEntry> entries : types.values()) {
                    for (ConfigEntry entry : entries) {
                        list.add(entry);
                    }
                }
            }
            ArrayList<ConfigEntry> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editConfigEntry(String id, ConfigEntry configEntry) throws RepositoryException {
        this.lock.writeLock().lock();
        try {
            Node entry = (Node)this.adminSession.getItem(id);
            this.setEntry(entry, configEntry);
            entry.save();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator eventIterator) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Hit> configs = new HashMap<String, Hit>();
        HashMap<String, String> deletedLookup = new HashMap<String, String>();
        while (eventIterator.hasNext()) {
            Event event = eventIterator.nextEvent();
            if (ObservationUtil.isExternal((Event)event)) continue;
            try {
                ArrayList<Event> forwardReadEvents;
                if (this.doSkip(event.getPath())) continue;
                if (event.getType() == 2 && eventIterator.hasNext()) {
                    forwardReadEvents = new ArrayList(3);
                    forwardReadEvents.add(event);
                    Event nextEvent = eventIterator.nextEvent();
                    forwardReadEvents.add(nextEvent);
                    if (nextEvent.getType() == 1 && nextEvent.getPath().equals(event.getPath()) && eventIterator.hasNext()) {
                        nextEvent = eventIterator.nextEvent();
                        forwardReadEvents.add(nextEvent);
                        if (nextEvent.getType() == 32 && nextEvent.getPath().equals(event.getPath()) && nextEvent.getInfo() != null && nextEvent.getInfo().containsKey("srcChildRelPath")) {
                            log.info("Ignoring NODE_REMOVED, NODE_ADDED, NODE_MOVED events for path " + event.getPath() + "; events are related to a node being re-ordered");
                            continue;
                        }
                    }
                } else {
                    forwardReadEvents = new ArrayList<Event>(1);
                    forwardReadEvents.add(event);
                }
                for (Event innerEvent : forwardReadEvents) {
                    if (innerEvent.getType() == 32) continue;
                    String path = innerEvent.getPath();
                    if (path.startsWith(LAUNCHER_CONFIG_ROOT)) {
                        this.reindex();
                        continue;
                    }
                    this.lock.readLock().lock();
                    try {
                        int eventType = innerEvent.getType();
                        Map<String, List<ConfigEntry>> configuredNodeTypes = this.config.get(this.getModType(eventType));
                        if (eventType != 2) {
                            Set<String> nts = configuredNodeTypes.keySet();
                            Filter filter = new NoOpFilter();
                            if (eventType == 1) {
                                filter = new NodeAddedFilter();
                            }
                            Item item = null;
                            try {
                                item = this.adminSession.getItem(path);
                            }
                            catch (RepositoryException re) {
                                log.debug("Cannot load item " + path + ". skipping.");
                            }
                            if (item == null) continue;
                            for (String nt : nts) {
                                this.resolve(path, nt, configuredNodeTypes.get(nt), configs, filter, nts, innerEvent, item);
                            }
                            continue;
                        }
                        try {
                            Node parent;
                            String nt;
                            List<ConfigEntry> entries;
                            deletedLookup.put(path, path);
                            String parentPath = path.substring(0, path.lastIndexOf("/"));
                            if (!this.adminSession.itemExists(parentPath) || (entries = configuredNodeTypes.get(nt = this.guessNodeType(parent = (Node)this.adminSession.getItem(parentPath), path, deletedLookup))) == null) continue;
                            for (ConfigEntry entry : entries) {
                                String key;
                                if (!this.isActiveConfig(entry) || !this.isMatchPath(path, entry.getGlob()) || configs.containsKey(key = path + "_#_" + String.valueOf(entry.hashCode()))) continue;
                                Hit hit = new Hit();
                                hit.setEntry(entry);
                                hit.setConfigEntry("userId", innerEvent.getUserID());
                                configs.put(key, hit);
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    catch (RepositoryException re) {
                        log.warn("Cannot resolve workflow launcher config", (Throwable)re);
                    }
                    finally {
                        this.lock.readLock().unlock();
                    }
                }
            }
            catch (RepositoryException e) {
                log.error("Error occurred while processing event", (Throwable)e);
            }
        }
        if (configs.size() > 0) {
            try {
                this.queue.put(configs);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Resolving launcher config took: " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    @Override
    public void run() {
        log.info("Waiting for startupFinished flag before starting workflows...");
        while (this.running && !this.startupFinished) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException iex) {
                log.warn("Interrupted while waiting for startup to be finished", (Throwable)iex);
            }
        }
        log.info("Startup finished, workflow queue processing starting");
        while (this.running) {
            Map<String, Hit> config = null;
            try {
                config = this.queue.take();
                log.debug("Backlog: " + this.queue.size());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (config == null || config.size() <= 0 || !this.running) continue;
            long startTime = System.currentTimeMillis();
            long executedWfs = this.executeWorkflows(config);
            log.debug("Starting workflows took: " + (System.currentTimeMillis() - startTime) + "ms (" + executedWfs + " workflows started)");
        }
        log.info("{} ends", (Object)Thread.currentThread().getName());
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        this.start(context.getProperties());
    }

    public void inform(StartupMode mode, boolean finished) {
        if (finished) {
            log.info("StartupListener.inform: startup finished");
            this.startupFinished = true;
        }
    }

    public void startupFinished(StartupMode mode) {
        log.info("StartupListener.startupFinished called");
        this.startupFinished = true;
    }

    public void startupProgress(float ratio) {
    }

    private void start(Dictionary<String, Object> props) throws RepositoryException {
        String[] executeAllwaysWorkflowModels;
        for (String model : executeAllwaysWorkflowModels = (String[])props.get(SYSTEM_WORKFLOW_MODELS)) {
            this.executeAllwaysWorkflowModelsMap.put(model, model);
        }
        this.adminSession = this.repository.loginAdministrative(null);
        this.adminSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 63, "/", true, null, null, false);
        this.wfSession = this.workflowService.getWorkflowSession(this.adminSession);
        this.setupPath(LAUNCHER_CONFIG_ROOT);
        this.config = new LauncherConfig();
        this.reindex();
        this.threadAdminSession = this.repository.loginAdministrative(null);
        this.threadWorkflowSession = this.workflowService.getWorkflowSession(this.threadAdminSession);
        this.running = true;
        Thread t = new Thread(this);
        t.setName("Workflow Starter Thread");
        t.start();
    }

    public void stop() {
        this.deactivate(null);
    }

    protected void deactivate(ComponentContext context) {
        if (this.adminSession != null) {
            try {
                this.adminSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                this.adminSession.logout();
                if (this.wfSession != null) {
                    this.wfSession.logout();
                }
            }
            catch (RepositoryException re) {
                // empty catch block
            }
            this.adminSession = null;
            this.wfSession = null;
        }
        if (this.threadAdminSession != null) {
            this.threadAdminSession.logout();
            if (this.threadWorkflowSession != null) {
                this.threadWorkflowSession.logout();
            }
            this.adminSession = null;
            this.wfSession = null;
            this.threadAdminSession = null;
            this.threadWorkflowSession = null;
        }
        this.running = false;
        try {
            this.queue.put(new HashMap());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private long executeWorkflows(Map<String, Hit> configs) {
        long executedWorkflows = 0L;
        Set<String> keys = configs.keySet();
        HashMap<String, String> createMap = new HashMap<String, String>();
        for (String key : keys) {
            ConfigEntry entry = configs.get(key).getEntry();
            if (entry.getEventType() != 1) continue;
            createMap.put(key.split("_#_")[0], "");
        }
        keys = configs.keySet();
        HashMap actions = new HashMap();
        for (String key : keys) {
            String cpath = key.split("_#_")[0];
            Hit hit = configs.get(key);
            ConfigEntry entry = hit.getEntry();
            if (createMap.containsKey(cpath) && entry.getEventType() != 1) continue;
            String workflow = entry.getWorkflow();
            String userId = (String)hit.getConfigEntry("userId");
            if (!actions.containsKey(cpath)) {
                actions.put(cpath, new ArrayList());
            }
            List wfList = (List)actions.get(cpath);
            boolean include = true;
            String workflowUserIdKey = workflow + "_#_" + userId;
            for (String wf : wfList) {
                if (!wf.equals(workflowUserIdKey)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            wfList.add(workflowUserIdKey);
        }
        for (String cpath : actions.keySet()) {
            List wfList = (List)actions.get(cpath);
            for (String wf : wfList) {
                String[] wfSplits = wf.split("_#_");
                this.startWorkflow(cpath, wfSplits[0], wfSplits[1]);
                ++executedWorkflows;
            }
        }
        return executedWorkflows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindex() {
        this.lock.readLock().lock();
        try {
            LauncherConfig conf = new LauncherConfig();
            Node confRoot = (Node)this.adminSession.getItem(LAUNCHER_CONFIG_ROOT);
            NodeIterator nodes = confRoot.getNodes();
            while (nodes.hasNext()) {
                Node entryNode = nodes.nextNode();
                ConfigEntry ce = new ConfigEntry((int)entryNode.getProperty("eventType").getLong(), entryNode.getProperty("glob").getString(), entryNode.getProperty("nodetype").getString(), entryNode.getProperty("condition").getString(), entryNode.getProperty("workflow").getString(), entryNode.getPath(), entryNode.getProperty("description").getString(), !entryNode.hasProperty("enabled") || entryNode.getProperty("enabled").getBoolean(), entryNode.hasProperty("excludeList") ? Arrays.asList(entryNode.getProperty("excludeList").getString().split(",")) : new ArrayList(), entryNode.hasProperty("runModes") ? Arrays.asList(entryNode.getProperty("runModes").getString().split(",")) : new ArrayList<String>());
                conf.add(ce);
            }
            this.config = conf;
            if (log.isDebugEnabled()) {
                log.debug("Reindexed config: " + conf.toString());
            }
        }
        catch (RepositoryException re) {
            log.error("Unable to reindex workflow launcher config", (Throwable)re);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void startWorkflow(String path, String workflow, String userId) {
        if (this.isInSameWorkflow(path, workflow)) {
            log.debug("Resource " + path + " already in workflow: " + workflow + ". Therefore not starting workflow.");
            return;
        }
        WorkflowModel model = null;
        try {
            model = this.threadWorkflowSession.getModel(workflow);
        }
        catch (WorkflowException we) {
            log.warn("Unable to load workflow model with id: " + workflow, (Throwable)we);
        }
        if (model != null) {
            log.debug("Auto assign workflow: found model (" + model.getTitle() + ") for " + path);
            WorkflowData wfData = this.threadWorkflowSession.newWorkflowData(TYPE_JCR_PATH, (Object)path);
            wfData.getMetaDataMap().put((Object)"userId", (Object)userId);
            try {
                try {
                    if (this.threadWorkflowSession.getSession().hasPendingChanges()) {
                        log.debug("Pending changes detected. Refreshing session");
                        this.threadWorkflowSession.getSession().refresh(false);
                    }
                }
                catch (RepositoryException re) {
                    log.warn("Pending changes detected but cannot refresh session: " + re.getMessage());
                }
                this.threadWorkflowSession.startWorkflow(model, wfData);
            }
            catch (WorkflowException we) {
                log.warn("Cannot start workflow " + model.getTitle() + " for " + path + ": " + we.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInSameWorkflow(String path, String workflow) {
        long startTime = System.currentTimeMillis();
        try {
            List wfs = this.payloadMap.getWorkflowInstances(path, true);
            if (wfs.size() > 0) {
                for (Workflow wf : wfs) {
                    try {
                        wf = this.wfSession.getWorkflow(wf.getId());
                    }
                    catch (WorkflowException we) {
                        // empty catch block
                    }
                    String workflowId = wf.getWorkflowModel().getId();
                    if (this.executeAllwaysWorkflowModelsMap.containsKey(workflowId)) {
                        log.debug(path + " is already in workflow " + workflowId + ". Exception for this model: START");
                        boolean bl = false;
                        return bl;
                    }
                    if (!workflowId.equals(workflow) || !wf.getState().equals("RUNNING")) continue;
                    log.info("Is in same workflow: " + workflow + " payload: " + path);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            log.debug("isInSameWorkflow: " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    private void resolve(String path, String nodetype, List<ConfigEntry> entries, Map<String, Hit> configs, Filter filter, Set<String> configuredNodetypes, Event event, Item item) throws RepositoryException {
        Node node;
        Node node2 = node = item.isNode() ? (Node)item : item.getParent();
        if (!node.isNodeType(nodetype) && configuredNodetypes.contains(nodetype) && !node.getPath().contains("/jcr:content")) {
            return;
        }
        while (!node.isNodeType(nodetype) && node.getDepth() > 0 && filter.check((Item)node)) {
            node = node.getParent();
        }
        if (node.isNodeType(nodetype)) {
            for (ConfigEntry entry : entries) {
                if (!this.isActiveConfig(entry)) continue;
                String whereClause = entry.getWhereClause();
                try {
                    String key;
                    if (whereClause != null && !"".equals(whereClause)) {
                        String key2;
                        String testValue;
                        String operator = whereClause.contains("==") ? "==" : "!=";
                        String[] splits = whereClause.split(operator);
                        String string = testValue = splits.length == 2 ? splits[1] : "";
                        if (!node.hasProperty(splits[0].trim())) continue;
                        String value = node.getProperty(splits[0].trim()).getString();
                        if (!this.isMatchPath(node.getPath(), entry.getGlob()) || this.exclude(path, entry.getGlob(), entry.getExcludeList()) || !this.compare(value, testValue, operator.equals("==")) || configs.containsKey(key2 = node.getPath() + "_#_" + String.valueOf(entry.hashCode()))) continue;
                        log.debug("ADDING:" + path);
                        Hit hit = new Hit();
                        hit.setEntry(entry);
                        hit.setConfigEntry("userId", event.getUserID());
                        configs.put(key2, hit);
                        continue;
                    }
                    if (!this.isMatchPath(node.getPath(), entry.getGlob()) || this.exclude(path, entry.getGlob(), entry.getExcludeList()) || configs.containsKey(key = node.getPath() + "_#_" + String.valueOf(entry.hashCode()))) continue;
                    log.debug("ADDING:" + path);
                    Hit hit = new Hit();
                    hit.setEntry(entry);
                    hit.setConfigEntry("userId", event.getUserID());
                    configs.put(key, hit);
                }
                catch (Throwable t) {}
            }
        }
    }

    private boolean compare(String value, String checkVal, boolean checkEqual) {
        if (checkEqual) {
            return value.equals(checkVal);
        }
        return !value.equals(checkVal);
    }

    private boolean exclude(String path, String glob, List<String> excludeList) {
        if (excludeList != null) {
            for (String relPath : excludeList) {
                String pattern = glob + (glob.endsWith("/") ? "" : "/") + relPath;
                if (!path.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMatchPath(String path, String glob) {
        if (path.startsWith(glob)) {
            return true;
        }
        return path.matches(glob);
    }

    private void setupPath(String path) throws RepositoryException {
        if (!this.adminSession.itemExists(path)) {
            String[] pathSplits = path.split("/");
            String pathToCheck = "";
            Node rootNode = this.adminSession.getRootNode();
            for (String pathSplit : pathSplits) {
                if (this.adminSession.itemExists(pathToCheck = pathToCheck.endsWith("/") ? pathToCheck + pathSplit : pathToCheck + "/" + pathSplit)) continue;
                rootNode.addNode(pathToCheck.substring(1), "sling:Folder");
            }
            rootNode.save();
        }
    }

    private boolean doSkip(String path) {
        for (Map.Entry<String, Pattern> entry : excludePathsPattern.entrySet()) {
            Pattern pattern = entry.getValue();
            Matcher matcher = pattern.matcher(path);
            if (!matcher.matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Ignore " + path);
            }
            return true;
        }
        return path.contains("/.DS_Store") || path.indexOf("/._") > 0;
    }

    private String guessNodeType(Node parent, String path, Map<String, String> lookup) {
        try {
            if (parent.isNodeType("nt:folder") && !parent.isNodeType("sling:Folder") && !lookup.containsKey(path + "/" + "jcr:content")) {
                return "nt:folder";
            }
            if (parent.isNodeType("nt:folder") && lookup.containsKey(path + "/" + "jcr:content") && !lookup.containsKey(path + "/" + "jcr:content" + "/renditions/original") && lookup.size() == 2) {
                return "nt:file";
            }
            if (parent.isNodeType("sling:Folder") && lookup.containsKey(path + "/" + "jcr:content" + "/renditions/original")) {
                return "dam:Asset";
            }
            if (parent.isNodeType("sling:Folder") && (lookup.size() == 1 || lookup.size() == 2)) {
                return "sling:Folder";
            }
            if (parent.isNodeType("sling:Folder")) {
                Set<String> keys = lookup.keySet();
                for (String key : keys) {
                    if (!key.matches("(.*/jcr:content.*)")) continue;
                    return "sling:Folder";
                }
            } else if (parent.isNodeType("cq:Page") && lookup.containsKey(path + "/" + "jcr:content")) {
                return "cq:Page";
            }
        }
        catch (RepositoryException re) {
            // empty catch block
        }
        return null;
    }

    private void setEntry(Node entryNode, ConfigEntry entry) throws RepositoryException {
        entryNode.setProperty("glob", entry.getGlob());
        entryNode.setProperty("condition", entry.getWhereClause());
        entryNode.setProperty("eventType", (long)entry.getEventType());
        entryNode.setProperty("description", entry.getDescription());
        entryNode.setProperty("nodetype", entry.getNodetype());
        entryNode.setProperty("workflow", entry.getWorkflow());
        entryNode.setProperty("enabled", entry.isEnabled());
        entryNode.setProperty("excludeList", this.serialize(entry.getExcludeList()));
        entryNode.setProperty("runModes", this.serialize(entry.getRunModes()));
    }

    private String serialize(List<String> excludeList) {
        String str = "";
        String comma = "";
        for (String item : excludeList) {
            str = str + comma + item;
            comma = ",";
        }
        return str;
    }

    private boolean isRunModeActive(String[] runModesToCheck) {
        boolean result = false;
        for (String m : runModesToCheck) {
            if ((m = m.trim()).equals("*")) {
                result = true;
                break;
            }
            if (!this.settingsService.getRunModes().contains(m)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isActiveConfig(ConfigEntry conf) {
        return (conf.getRunModes().size() == 0 || this.isRunModeActive(conf.getRunModes().toArray(new String[conf.getRunModes().size()]))) && conf.isEnabled();
    }

    private int getModType(int eventType) {
        if (eventType == 4 || eventType == 8 || eventType == 16) {
            return 16;
        }
        return eventType;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }

    protected void bindPayloadMap(PayloadMap payloadMap) {
        this.payloadMap = payloadMap;
    }

    protected void unbindPayloadMap(PayloadMap payloadMap) {
        if (this.payloadMap == payloadMap) {
            this.payloadMap = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    class Hit {
        private ConfigEntry entry;
        private Dictionary<String, Object> config = new Hashtable<String, Object>();

        Hit() {
        }

        public ConfigEntry getEntry() {
            return this.entry;
        }

        public void setEntry(ConfigEntry entry) {
            this.entry = entry;
        }

        public Object getConfigEntry(String key) {
            return this.config.get(key);
        }

        public void setConfigEntry(String key, Object object) {
            this.config.put(key, object);
        }
    }

    class NoOpFilter
    implements Filter {
        NoOpFilter() {
        }

        public boolean check(Item item) {
            return true;
        }
    }

    class NodeAddedFilter
    implements Filter {
        NodeAddedFilter() {
        }

        public boolean check(Item item) {
            try {
                return item.getName().indexOf("jcr:content") < 0;
            }
            catch (RepositoryException re) {
                return false;
            }
        }
    }

    static interface Filter {
        public boolean check(Item var1);
    }
}

