/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.commons.JSONWriterUtil;
import com.day.cq.commons.RangeIterator;
import com.day.cq.security.Authorizable;
import com.day.cq.security.Group;
import com.day.cq.security.User;
import com.day.cq.security.UserManager;
import com.day.cq.security.UserManagerFactory;
import com.day.cq.security.profile.Profile;
import com.day.cq.xss.XSSProtectionService;
import java.io.IOException;
import java.io.Writer;
import javax.jcr.AccessDeniedException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

public class AuthorizablesServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -9028132962410339395L;
    private static final String PARAM_QUERY = "query";
    private static final String PARAM_LIMIT = "limit";
    private static final String PARAM_START = "start";
    private static final String PARAM_HIDE_GROUPS = "hideGroups";
    private static final String PARAM_HIDE_USERS = "hideUsers";
    private static final String USER_ICON_PATH = "/libs/cq/ui/widgets/themes/default/icons/48x48/user.png";
    private static final String GROUP_ICON_PATH = "/libs/cq/ui/widgets/themes/default/icons/48x48/group.png";
    private UserManagerFactory userManagerFactory;
    private XSSProtectionService xss;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        HtmlResponse htmlResponse = new HtmlResponse();
        if (this.userManagerFactory == null) {
            htmlResponse.setStatus(503, "UserManagerFactory not available");
            return;
        }
        if (!"json".equals(request.getRequestPathInfo().getExtension())) {
            htmlResponse.setStatus(400, "Only service JSON requests");
            return;
        }
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            RequestParameterMap params = request.getRequestParameterMap();
            String query = "";
            if (params.getValue(PARAM_QUERY) != null) {
                query = params.getValue(PARAM_QUERY).getString();
            }
            Class<Authorizable> type = Authorizable.class;
            if (params.getValue(PARAM_HIDE_USERS) != null && Boolean.valueOf(params.getValue(PARAM_HIDE_USERS).getString()).booleanValue()) {
                type = Group.class;
            } else if (params.getValue(PARAM_HIDE_GROUPS) != null && Boolean.valueOf(params.getValue(PARAM_HIDE_GROUPS).getString()).booleanValue()) {
                type = User.class;
            }
            int limit = -1;
            if (params.getValue(PARAM_LIMIT) != null) {
                try {
                    limit = Integer.valueOf(params.getValue(PARAM_LIMIT).getString());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            int start = 0;
            if (params.getValue(PARAM_START) != null) {
                try {
                    start = Integer.valueOf(params.getValue(PARAM_START).getString());
                    if (limit > -1) {
                        limit += start;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            UserManager uMgr = this.userManagerFactory.createUserManager(session);
            JSONWriter writer = new JSONWriter((Writer)response.getWriter());
            RangeIterator res = uMgr.find(query, type);
            if (start > -1 && (long)start <= res.getSize()) {
                res.skip((long)start);
            }
            writer.object();
            writer.key("authorizables");
            writer.array();
            while (res.hasNext()) {
                Authorizable auth = (Authorizable)res.next();
                writer.object();
                writer.key("path").value((Object)auth.getHomePath());
                writer.key("id").value((Object)auth.getID());
                JSONWriterUtil.write((JSONWriter)writer, (String)"name", (String)auth.getName(), (JSONWriterUtil.WriteMode)JSONWriterUtil.WriteMode.AVOID_XSS, (XSSProtectionService)this.xss);
                writer.key("image").value((Object)this.getAvatar(auth, request));
                writer.key("email").value((Object)this.getEmail(auth));
                writer.endObject();
                if (limit <= -1 || res.getPosition() != (long)limit) continue;
                break;
            }
            writer.endArray();
            writer.key("results").value(res.getSize());
            writer.endObject();
        }
        catch (AccessDeniedException e) {
            htmlResponse.setStatus(401, "");
        }
        catch (JSONException e) {
            htmlResponse.setError((Throwable)e);
        }
    }

    protected String getAvatar(Authorizable auth, SlingHttpServletRequest request) {
        Profile profile = auth.getProfile();
        return profile.getAvatarURL(".thumb.48.48.png", auth.isUser() ? request.getContextPath() + USER_ICON_PATH : GROUP_ICON_PATH);
    }

    protected String getEmail(Authorizable auth) {
        return auth.getProfile().getPrimaryMail() != null ? auth.getProfile().getPrimaryMail() : "";
    }

    protected void bindUserManagerFactory(UserManagerFactory userManagerFactory) {
        this.userManagerFactory = userManagerFactory;
    }

    protected void unbindUserManagerFactory(UserManagerFactory userManagerFactory) {
        if (this.userManagerFactory == userManagerFactory) {
            this.userManagerFactory = null;
        }
    }

    protected void bindXss(XSSProtectionService xSSProtectionService) {
        this.xss = xSSProtectionService;
    }

    protected void unbindXss(XSSProtectionService xSSProtectionService) {
        if (this.xss == xSSProtectionService) {
            this.xss = null;
        }
    }
}

