/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.workflow.exec.JavaProcess;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.servlet.WorkflowConsoleUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -780464494271946961L;
    private final Logger log = LoggerFactory.getLogger(ConsoleServlet.class);
    private ComponentContext context;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        String[] selectors = request.getRequestPathInfo().getSelectors();
        if (selectors != null && selectors.length == 1 && selectors[0].equals("processes") && request.getRequestPathInfo().getExtension().equals("json")) {
            try {
                List<ServiceReference> refs = WorkflowConsoleUtil.getServiceReferences(this.context, Arrays.asList(WorkflowProcess.class.getName(), JavaProcess.class.getName()));
                writer.object();
                if (refs != null) {
                    for (ServiceReference serviceReference : refs) {
                        String className = this.getProcessClassName(serviceReference);
                        if (className == null) continue;
                        writer.key("option");
                        writer.object();
                        writer.key("value").value((Object)className);
                        writer.key("text").value((Object)className);
                        writer.endObject();
                    }
                }
                writer.endObject();
            }
            catch (InvalidSyntaxException e) {
                throw new ServletException("Could not lookup java processes.", (Throwable)e);
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private String getProcessClassName(ServiceReference serviceReference) {
        String processClassName = null;
        Object process = this.context.getBundleContext().getService(serviceReference);
        if (process != null) {
            if (process instanceof WorkflowProcess) {
                WorkflowProcess processImpl = (WorkflowProcess)process;
                processClassName = processImpl.getClass().getName();
            } else if (process instanceof JavaProcess) {
                JavaProcess processImpl = (JavaProcess)process;
                processClassName = processImpl.getClass().getName();
            } else {
                this.log.error("unsupported process implementation found " + process);
            }
        }
        return processClassName;
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        this.context = context;
    }
}

