/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.security.Authorizable;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Route;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.model.WorkflowNode;
import com.day.cq.workflow.model.WorkflowTransition;
import com.day.cq.workflow.servlet.ServletBase;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InboxServlet
extends ServletBase {
    private static final long serialVersionUID = -3596348616959666034L;
    private static final String CMD_ADVANCE = "advance";
    private static final String CMD_ADVANCE_BACK = "advanceBack";
    private static final String CMD_DELEGATE = "delegate";
    private static final String P_CMD = "cmd";
    private static final String P_ROUTE = "route";
    private static final String P_BACK_ROUTE = "backroute";
    private static final String P_ITEM = "item";
    private static final String P_DELEGATEE = "delegatee";
    private static final String[] META_DATA_EXCLUDES = new String[]{"cmd", "item", "route", "backroute", "delegatee"};
    private WorkflowService workflowService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        WorkflowSession wfSession = this.workflowService.getWorkflowSession(session);
        WorkItem[] items = null;
        try {
            items = wfSession.getActiveWorkItems();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        try {
            writer.array();
            for (int i = 0; i < items.length; ++i) {
                WorkItem item = items[i];
                writer.object();
                writer.key("uri").value((Object)(request.getContextPath() + item.getId()));
                writer.endObject();
            }
            writer.endArray();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block22: {
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            WorkflowSession wfSession = this.workflowService.getWorkflowSession(session);
            RequestParameterMap params = request.getRequestParameterMap();
            RequestParameter cmd = params.getValue(P_CMD);
            if (cmd == null) {
                RequestParameter itemIdParam = params.getValue(P_ITEM);
                RequestParameter routeIdParam = params.getValue(P_ROUTE);
                RequestParameter backRouteIdParam = params.getValue(P_BACK_ROUTE);
                RequestParameter delegateeIdParam = params.getValue(P_DELEGATEE);
                try {
                    if (itemIdParam != null && routeIdParam != null) {
                        this.advance(params, wfSession, itemIdParam.getString(), routeIdParam.getString());
                        this.sendResponse((HttpServletResponse)response, 200, "Workflow(s) advanced");
                        break block22;
                    }
                    if (itemIdParam != null && backRouteIdParam != null) {
                        this.advanceBack(params, wfSession, itemIdParam.getString(), backRouteIdParam.getString());
                        this.sendResponse((HttpServletResponse)response, 200, "Workflow(s) advanced back");
                        break block22;
                    }
                    if (itemIdParam != null && delegateeIdParam != null) {
                        this.delegate(response, wfSession, params, itemIdParam.getString(), delegateeIdParam.getString());
                        this.sendResponse((HttpServletResponse)response, 200, "Work Item(s) delegated");
                        break block22;
                    }
                    this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
                }
                catch (WorkflowException e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            } else {
                RequestParameter[] itemIdParams = params.getValues(P_ITEM);
                if (CMD_ADVANCE.equals(cmd.getString()) && itemIdParams != null && itemIdParams.length > 0) {
                    Map<String, String> p = this.collectParams(P_ROUTE, response, params, itemIdParams);
                    if (p != null) {
                        try {
                            this.advance(response, params, wfSession, p);
                        }
                        catch (WorkflowException e) {
                            this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                        }
                    }
                } else if (CMD_DELEGATE.equals(cmd.getString()) && itemIdParams != null && itemIdParams.length > 0) {
                    Map<String, String> p = this.collectParams(P_DELEGATEE, response, params, itemIdParams);
                    if (p != null) {
                        try {
                            this.delegate(response, wfSession, params, p);
                        }
                        catch (WorkflowException e) {
                            this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                        }
                    }
                } else if (CMD_ADVANCE_BACK.equals(cmd.getString()) && itemIdParams != null && itemIdParams.length > 0) {
                    Map<String, String> p = this.collectParams(P_BACK_ROUTE, response, params, itemIdParams);
                    if (p != null) {
                        try {
                            this.advanceBack(response, wfSession, params, p);
                        }
                        catch (WorkflowException e) {
                            this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                        }
                    }
                } else {
                    this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
                }
            }
        }
    }

    private Map<String, String> collectParams(String namePrefix, SlingHttpServletResponse response, RequestParameterMap params, RequestParameter[] itemIdParams) {
        HashMap<String, String> p = new HashMap<String, String>();
        for (RequestParameter itemIdParam : itemIdParams) {
            String itemId = itemIdParam.getString();
            RequestParameter param = params.getValue(namePrefix + "-" + itemId);
            if (param == null) {
                this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
                return null;
            }
            String val = param.getString();
            p.put(itemId, val);
        }
        return p;
    }

    private void delegate(SlingHttpServletResponse response, WorkflowSession wfSession, RequestParameterMap params, Map<String, String> p) throws AccessControlException, WorkflowException {
        for (String itemId : p.keySet()) {
            String delegateeId = p.get(itemId);
            this.delegate(response, wfSession, params, itemId, delegateeId);
        }
        this.sendResponse((HttpServletResponse)response, 200, "Work item(s) delegated");
    }

    private void delegate(SlingHttpServletResponse response, WorkflowSession wfSession, RequestParameterMap params, String itemId, String delegateeId) throws WorkflowException {
        boolean delegated = false;
        WorkItem item = wfSession.getWorkItem(itemId);
        List delegatees = wfSession.getDelegatees(item);
        for (Authorizable delegatee : delegatees) {
            if (!delegatee.getID().equals(delegateeId)) continue;
            this.updateMetaData(params, item);
            wfSession.delegateWorkItem(item, delegatee);
            delegated = true;
            break;
        }
        if (!delegated) {
            this.sendResponse((HttpServletResponse)response, 500, "Delegatee '" + delegateeId + "' not found");
            return;
        }
    }

    private void advanceBack(SlingHttpServletResponse response, WorkflowSession wfSession, RequestParameterMap params, Map<String, String> p) throws WorkflowException {
        for (String itemId : p.keySet()) {
            String routeId = p.get(itemId);
            this.advanceBack(params, wfSession, itemId, routeId);
        }
        this.sendResponse((HttpServletResponse)response, 200, "Workflow(s) advanced back");
    }

    private void advanceBack(RequestParameterMap params, WorkflowSession wfSession, String itemId, String routeId) throws WorkflowException {
        WorkItem item = wfSession.getWorkItem(itemId);
        List routes = wfSession.getBackRoutes(item, true);
        this.findRouteAndAdvance(wfSession, params, routeId, item, routes);
    }

    private void advance(SlingHttpServletResponse response, RequestParameterMap params, WorkflowSession wfSession, Map<String, String> p) throws WorkflowException {
        for (String itemId : p.keySet()) {
            String routeId = p.get(itemId);
            this.advance(params, wfSession, itemId, routeId);
        }
        this.sendResponse((HttpServletResponse)response, 200, "Workflow(s) advanced");
    }

    private void advance(RequestParameterMap params, WorkflowSession wfSession, String itemId, String routeId) throws WorkflowException {
        WorkItem item = wfSession.getWorkItem(itemId);
        List routes = wfSession.getRoutes(item, true);
        this.findRouteAndAdvance(wfSession, params, routeId, item, routes);
    }

    private void findRouteAndAdvance(WorkflowSession wfSession, RequestParameterMap params, String routeId, WorkItem item, List<Route> routes) throws WorkflowException {
        for (Route route : routes) {
            WorkflowNode node;
            String cRouteId = route.getId();
            if (cRouteId.equals(routeId)) {
                this.updateMetaData(params, item);
                wfSession.complete(item, route);
                break;
            }
            if (!routeId.contains("@") || !(node = ((WorkflowTransition)route.getDestinations().get(0)).getTo()).getType().equals("PARTICIPANT")) continue;
            String participant = (String)node.getMetaDataMap().get("PARTICIPANT", String.class);
            if (!routeId.startsWith(cRouteId + "@") || !routeId.endsWith("@" + participant)) continue;
            this.updateMetaData(params, item);
            wfSession.complete(item, route);
            break;
        }
    }

    protected void updateMetaData(RequestParameterMap params, WorkItem item) {
        MetaDataMap metaData = item.getMetaDataMap();
        RequestParameter cmd = params.getValue(P_CMD);
        if (cmd == null) {
            List<String> excludes = Arrays.asList(DEFAULT_META_DATA_EXCLUDES);
            for (String key : params.keySet()) {
                if (excludes.contains(key) || this.getMetaDataExcludes(params).contains(key)) continue;
                RequestParameter para = params.getValue(key);
                metaData.put((Object)key, (Object)para.getString());
            }
        } else {
            String suffix = "-" + item.getId();
            RequestParameter[] itemIdParams = params.getValues(P_ITEM);
            List<String> excludes = Arrays.asList(DEFAULT_META_DATA_EXCLUDES);
            for (String key : params.keySet()) {
                RequestParameter para;
                if (excludes.contains(key) || this.getMetaDataExcludes(params).contains(key)) continue;
                boolean hasSuffix = false;
                if (key.endsWith(suffix)) {
                    para = params.getValue(key);
                    key = key.substring(0, key.indexOf(suffix));
                    metaData.put((Object)key, (Object)para.getString());
                    hasSuffix = true;
                } else {
                    for (RequestParameter itemIdParam : itemIdParams) {
                        if (!key.endsWith("-" + itemIdParam.getString())) continue;
                        hasSuffix = true;
                        break;
                    }
                }
                if (hasSuffix) continue;
                para = params.getValue(key);
                metaData.put((Object)key, (Object)para.getString());
            }
        }
    }

    @Override
    protected List<String> getMetaDataExcludes(RequestParameterMap params) {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.addAll(Arrays.asList(META_DATA_EXCLUDES));
        for (String name : params.keySet()) {
            if (!name.startsWith("route-") && !name.startsWith("backroute-") && !name.startsWith("delegatee-")) continue;
            excludes.add(name);
        }
        return excludes;
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }
}

