/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.servlet.ServletBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceServlet
extends ServletBase {
    private static final long serialVersionUID = 2171661388034822790L;
    private static final String STATE_PARAM_NAME = "state";
    private static final String ACTION_PARAM_NAME = "action";
    private static final String[] META_DATA_EXCLUDES = new String[]{"state"};
    private WorkflowService workflowService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        RequestParameterMap params = request.getRequestParameterMap();
        WorkflowSession wfSession = this.workflowService.getWorkflowSession(session);
        Node node = (Node)request.getResource().adaptTo(Node.class);
        RequestParameter state = params.getValue(STATE_PARAM_NAME);
        RequestParameter action = params.getValue(ACTION_PARAM_NAME);
        if (state != null) {
            try {
                Workflow workflow = wfSession.getWorkflow(node.getPath());
                this.updateMetaData(params, workflow);
                if (state.getString().equals("SUSPENDED")) {
                    wfSession.suspendWorkflow(workflow);
                    this.sendResponse((HttpServletResponse)response, 200, "Workflow suspended");
                } else if (state.getString().equals("RUNNING")) {
                    wfSession.resumeWorkflow(workflow);
                    this.sendResponse((HttpServletResponse)response, 200, "Workflow resumed");
                } else if (state.getString().equals("ABORTED")) {
                    wfSession.terminateWorkflow(workflow);
                    this.sendResponse((HttpServletResponse)response, 200, "Workflow aborted");
                }
            }
            catch (IllegalStateException e) {
                this.sendResponse((HttpServletResponse)response, 409, e.getMessage());
            }
            catch (Exception e) {
                this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
            }
        } else if (action != null) {
            if (action.getString().equals("UPDATE")) {
                try {
                    Workflow workflow = wfSession.getWorkflow(node.getPath());
                    this.updateMetaData(params, workflow);
                    wfSession.updateWorkflowData(workflow, workflow.getWorkflowData());
                    this.sendResponse((HttpServletResponse)response, 200, "Workflow MetaData updated");
                }
                catch (Exception e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            }
        } else {
            this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
        }
    }

    private void updateMetaData(RequestParameterMap params, Workflow workflow) {
        for (String key : params.keySet()) {
            if (key.equals(STATE_PARAM_NAME) || key.equals(ACTION_PARAM_NAME) || key.startsWith(":") || key.startsWith("./")) continue;
            RequestParameter para = params.getValue(key);
            workflow.getMetaDataMap().put((Object)key, (Object)para.getString());
            workflow.getWorkflowData().getMetaDataMap().put((Object)key, (Object)para.getString());
        }
    }

    @Override
    protected List<String> getMetaDataExcludes(RequestParameterMap params) {
        return Arrays.asList(META_DATA_EXCLUDES);
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }
}

