/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.model.WorkflowModel;
import com.day.cq.workflow.servlet.ServletBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstancesServlet
extends ServletBase {
    private static final long serialVersionUID = 2031517619398541804L;
    private static final String PAYLOAD_TYPE_PARAM_NAME = "payloadType";
    private static final String PAYLOAD_PARAM_NAME = "payload";
    private static final String MODEL_PARAM_NAME = "model";
    private static final String[] META_DATA_EXCLUDES = new String[]{"payloadType", "payload", "model"};
    private WorkflowService workflowService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        RequestParameterMap params = request.getRequestParameterMap();
        WorkflowSession wfSession = this.workflowService.getWorkflowSession(session);
        RequestParameter modelParam = params.getValue(MODEL_PARAM_NAME);
        RequestParameter typeParam = params.getValue(PAYLOAD_TYPE_PARAM_NAME);
        RequestParameter[] payloadParams = params.getValues(PAYLOAD_PARAM_NAME);
        if (modelParam != null && payloadParams != null && typeParam != null) {
            String modelId = modelParam.getString();
            String payloadType = typeParam.getString();
            String url = "";
            for (RequestParameter payloadParam : payloadParams) {
                try {
                    WorkflowModel model = wfSession.getModel(modelId);
                    WorkflowData data = wfSession.newWorkflowData(payloadType, (Object)payloadParam.getString());
                    HashMap<String, Object> metaData = new HashMap<String, Object>();
                    this.updateMetaData(params, metaData);
                    Workflow workflow = wfSession.startWorkflow(model, data, metaData);
                    url = this.getUrl(request, workflow.getId());
                }
                catch (WorkflowException e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                    return;
                }
            }
            this.sendResourceCreatedResponse((HttpServletResponse)response, url);
        } else {
            this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
        }
    }

    @Override
    protected List<String> getMetaDataExcludes(RequestParameterMap params) {
        return Arrays.asList(META_DATA_EXCLUDES);
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }
}

