/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.security.Authorizable;
import com.day.cq.security.UserManager;
import com.day.cq.security.UserManagerFactory;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowModel;
import com.day.cq.workflow.model.WorkflowNode;
import com.day.cq.workflow.model.WorkflowTransition;
import com.day.jcr.vault.util.Text;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.util.TraversingItemVisitor;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelGenerateServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -7850496483294071571L;
    private static final Logger log = LoggerFactory.getLogger(ModelGenerateServlet.class);
    private static final String STEP_RES_TYPE = "cq/workflow/components/model/step";
    private static final String SPLIT_RES_TYPE = "cq/flow/components/control/split";
    private static final String PARTICIPANT_RES_TYPE = "cq/workflow/components/model/participant";
    private static final String DYNAMIC_PARTICIPANT_RES_TYPE = "cq/workflow/components/model/dynamic_participant";
    private static final String PROCESS_RES_TYPE = "cq/workflow/components/model/process";
    private static final String CONTAINER_RES_TYPE = "cq/workflow/components/model/container";
    private static final String EXTERNAL_PROCESS_RES_TYPE = "cq/workflow/components/model/external_process";
    private static final String WORKFLOW_TAG_NAMESPACE = "workflow:";
    private Map<String, String> STEP_MAPPINGS = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(ModelGenerateServlet.PARTICIPANT_RES_TYPE, "PARTICIPANT");
            this.put(ModelGenerateServlet.DYNAMIC_PARTICIPANT_RES_TYPE, "DYNAMIC_PARTICIPANT");
            this.put(ModelGenerateServlet.PROCESS_RES_TYPE, "PROCESS");
            this.put(ModelGenerateServlet.CONTAINER_RES_TYPE, "CONTAINER");
            this.put(ModelGenerateServlet.EXTERNAL_PROCESS_RES_TYPE, "EXTERNAL_PROCESS");
        }
    };
    private WorkflowService wfSvc;
    private UserManagerFactory umFactory;

    protected void doPost(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        ResourceResolver resolver = req.getResourceResolver();
        Session sess = (Session)resolver.adaptTo(Session.class);
        WorkflowSession wfSess = this.wfSvc.getWorkflowSession(sess);
        Resource res = req.getResource();
        ValueMap props = (ValueMap)res.adaptTo(ValueMap.class);
        String title = (String)props.get("jcr:title", (Object)"No Title");
        String desc = (String)props.get("jcr:description", (Object)"No Description");
        String msg = "Model successfully generated.";
        String modelPath = null;
        try {
            Node content = (Node)res.adaptTo(Node.class);
            if (content.hasNode("flow")) {
                String modelId = content.getPath() + "/model";
                WorkflowModel model = wfSess.getModel(modelId);
                if (model == null) {
                    model = wfSess.createNewModel(title, modelId);
                }
                model.setTitle(title);
                model.setDescription(desc);
                this.setTags(model, content);
                model.getNodes().clear();
                model.getTransitions().clear();
                ContentVisitor v = new ContentVisitor(resolver, model);
                v.visit(content.getNode("flow"));
                model = v.getModel();
                modelPath = model.getId();
                long now = Calendar.getInstance().getTimeInMillis();
                model.getMetaDataMap().put((Object)"cq:lastModified", (Object)now);
                model.getMetaDataMap().put((Object)"cq:lastModifiedBy", (Object)sess.getUserID());
                wfSess.deployModel(model);
            }
        }
        catch (Exception e) {
            this.log("Could not create workflow model", e);
            msg = "Could not create workflow model. " + e.getMessage();
            resp.setStatus(500);
        }
        JSONWriter w = new JSONWriter((Writer)resp.getWriter());
        try {
            w.object();
            w.key("msg").value((Object)msg);
            if (modelPath != null) {
                w.key("modelPath").value(modelPath);
            }
            w.endObject();
        }
        catch (JSONException e) {
            this.log("Error", e);
        }
    }

    private void setTags(WorkflowModel model, Node content) throws RepositoryException {
        if (content.hasProperty("cq:tags")) {
            ArrayList<String> tags = new ArrayList<String>();
            for (Value v : content.getProperty("cq:tags").getValues()) {
                if (!v.getString().startsWith(WORKFLOW_TAG_NAMESPACE)) continue;
                tags.add(v.getString().substring(WORKFLOW_TAG_NAMESPACE.length()).replace('/', '.'));
            }
            model.getMetaDataMap().put((Object)"tags", (Object)Text.implode((String[])tags.toArray(new String[tags.size()]), (String)","));
        }
    }

    protected void bindWfSvc(WorkflowService workflowService) {
        this.wfSvc = workflowService;
    }

    protected void unbindWfSvc(WorkflowService workflowService) {
        if (this.wfSvc == workflowService) {
            this.wfSvc = null;
        }
    }

    protected void bindUmFactory(UserManagerFactory userManagerFactory) {
        this.umFactory = userManagerFactory;
    }

    protected void unbindUmFactory(UserManagerFactory userManagerFactory) {
        if (this.umFactory == userManagerFactory) {
            this.umFactory = null;
        }
    }

    private class ContentVisitor
    extends TraversingItemVisitor.Default {
        private ResourceResolver resolver;
        private WorkflowModel model;
        private Resource flow;
        private Map<WorkflowNode, ValueMap> rules = new HashMap<WorkflowNode, ValueMap>();
        private Stack<List<WorkflowNode>> nested = new Stack();

        public ContentVisitor(ResourceResolver res, WorkflowModel m) {
            this.resolver = res;
            this.model = m;
        }

        public WorkflowModel getModel() {
            return this.model;
        }

        protected void entering(Node node, int level) throws RepositoryException {
            Resource res = this.resolver.getResource(node.getPath());
            ValueMap props = (ValueMap)res.adaptTo(ValueMap.class);
            log.info("Entering " + res);
            if (res != null) {
                Resource parent = ResourceUtil.getParent((Resource)res);
                if (this.flow == null) {
                    this.flow = res;
                    ArrayList<WorkflowNode> current = new ArrayList<WorkflowNode>();
                    this.nested.push(current);
                    WorkflowNode start = this.model.createNode("Start", "START", null);
                    this.model.setRootNode(start);
                    current.add(start);
                } else if (ResourceUtil.isA((Resource)res, (String)ModelGenerateServlet.SPLIT_RES_TYPE)) {
                    boolean isOr = "true".equals(props.get("orSplit", (Object)""));
                    String st = isOr ? "OR_SPLIT" : "AND_SPLIT";
                    String jt = isOr ? "OR_JOIN" : "AND_JOIN";
                    WorkflowNode split = this.model.createNode(st, st, null);
                    WorkflowNode join = this.model.createNode(jt, jt, null);
                    List<WorkflowNode> current = this.nested.peek();
                    WorkflowNode last = current.get(current.size() - 1);
                    if (this.nested.size() > 1) {
                        last = current.get(current.size() - 2);
                        current.add(current.size() - 1, split);
                        current.add(current.size() - 1, join);
                    } else {
                        current.add(split);
                        current.add(join);
                    }
                    this.model.createTransition(last, split, null);
                    if (isOr) {
                        this.rules.put(split, props);
                    }
                } else if (ResourceUtil.isA((Resource)parent, (String)ModelGenerateServlet.SPLIT_RES_TYPE)) {
                    WorkflowNode join;
                    WorkflowNode split;
                    List<WorkflowNode> current = this.nested.peek();
                    if (this.nested.size() > 1) {
                        split = current.get(current.size() - 3);
                        join = current.get(current.size() - 2);
                    } else {
                        split = current.get(current.size() - 2);
                        join = current.get(current.size() - 1);
                    }
                    ArrayList<WorkflowNode> next = new ArrayList<WorkflowNode>();
                    this.nested.push(next);
                    next.add(split);
                    next.add(join);
                } else if (ResourceUtil.isA((Resource)res, (String)ModelGenerateServlet.STEP_RES_TYPE)) {
                    this.handleStep(res, props);
                }
            }
        }

        protected void leaving(Node node, int level) throws RepositoryException {
            Resource res = this.resolver.getResource(node.getPath());
            log.info("Leaving " + res);
            if (res != null) {
                Resource parent = ResourceUtil.getParent((Resource)res);
                if (this.flow.getPath().equals(res.getPath())) {
                    WorkflowNode end = this.model.createNode("End", "END", null);
                    this.model.setEndNode(end);
                    List<WorkflowNode> current = this.nested.pop();
                    WorkflowNode last = current.get(current.size() - 1);
                    this.model.createTransition(last, end, null);
                    this.flow = null;
                } else if (ResourceUtil.isA((Resource)parent, (String)ModelGenerateServlet.SPLIT_RES_TYPE)) {
                    List<WorkflowNode> prev = this.nested.pop();
                    WorkflowNode last = prev.get(prev.size() - 2);
                    WorkflowNode join = prev.get(prev.size() - 1);
                    this.model.createTransition(last, join, null);
                }
            }
        }

        private WorkflowNode handleStep(Resource res, ValueMap props) {
            String title = (String)props.get("jcr:title", String.class);
            String desc = (String)props.get("jcr:description", String.class);
            String type = this.getStepType(res);
            WorkflowNode node = this.model.createNode(title, type, desc);
            this.copyMetaData(res, node);
            List<WorkflowNode> current = this.nested.peek();
            WorkflowNode last = current.get(current.size() - 1);
            if (this.nested.size() > 1) {
                last = current.get(current.size() - 2);
                current.add(current.size() - 1, node);
            } else {
                current.add(node);
            }
            if (last.getType().equals("OR_SPLIT") && this.rules.get(last) != null) {
                int branch = last.getTransitions().size() + 1;
                String rule = "";
                if (this.rules.get(last).containsKey((Object)("scriptPath" + branch))) {
                    rule = (String)this.rules.get(last).get((Object)("scriptPath" + branch));
                } else if (this.rules.get(last).containsKey((Object)("script" + branch))) {
                    rule = (String)this.rules.get(last).get((Object)("script" + branch));
                }
                WorkflowTransition transition = this.model.createTransition(last, node, rule);
                String defaultRoute = (String)this.rules.get(last).get((Object)("default" + branch));
                transition.getMetaDataMap().put((Object)"isDefault", (Object)(defaultRoute != null ? defaultRoute : "false"));
            } else {
                this.model.createTransition(last, node, "");
            }
            return node;
        }

        private String getStepType(Resource res) {
            for (String resType : ModelGenerateServlet.this.STEP_MAPPINGS.keySet()) {
                if (!ResourceUtil.isA((Resource)res, (String)resType)) continue;
                return (String)ModelGenerateServlet.this.STEP_MAPPINGS.get(resType);
            }
            log.error("Not a valid workflow step resource: {}", (Object)res);
            return null;
        }

        private void copyMetaData(Resource res, WorkflowNode node) {
            ResourceResolver resolver = res.getResourceResolver();
            Resource meta = resolver.getResource(res.getPath() + "/metaData");
            if (meta == null) {
                log.error("no metaData node available for resource " + res.getPath());
                return;
            }
            Node metaDataNode = (Node)meta.adaptTo(Node.class);
            try {
                PropertyIterator pIt = metaDataNode.getProperties();
                while (pIt.hasNext()) {
                    Property prop = pIt.nextProperty();
                    if (prop.getName().startsWith("jcr:")) continue;
                    if (prop.getName().equals("PARTICIPANT")) {
                        try {
                            String value = prop.getString();
                            UserManager um = ModelGenerateServlet.this.umFactory.createUserManager((Session)resolver.adaptTo(Session.class));
                            Authorizable auth = value.startsWith("/") ? um.findByHome(value) : um.get(value);
                            value = auth.getID();
                            node.getMetaDataMap().put((Object)prop.getName(), (Object)value);
                        }
                        catch (AccessDeniedException e) {
                            log.error("Could not get user manager {}", (Throwable)e);
                        }
                        continue;
                    }
                    if (prop.isMultiple()) {
                        node.getMetaDataMap().put((Object)prop.getName(), (Object)prop.getValues());
                        continue;
                    }
                    node.getMetaDataMap().put((Object)prop.getName(), (Object)prop.getValue());
                }
            }
            catch (ValueFormatException vfe) {
                log.error(vfe.getMessage(), (Throwable)vfe);
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

