/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowModel;
import com.day.cq.workflow.serialization.SerializationService;
import com.day.cq.workflow.servlet.ServletBase;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelsServlet
extends ServletBase {
    private static final long serialVersionUID = 937308391948022139L;
    private WorkflowService workflowService;
    private SerializationService serSvc;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        RequestParameterMap params = request.getRequestParameterMap();
        WorkflowSession wfSession = this.workflowService.getWorkflowSession(session);
        RequestParameter reqPara = null;
        RequestParameter typePara = null;
        reqPara = params.getValue("delete");
        if (reqPara != null) {
            try {
                wfSession.deleteModel(reqPara.getString());
            }
            catch (Exception e) {
                this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
            }
        } else {
            reqPara = params.getValue("title");
            if (reqPara != null) {
                String name = reqPara.getString();
                try {
                    WorkflowModel model = wfSession.createNewModel(name);
                    this.sendResourceCreatedResponse((HttpServletResponse)response, this.getUrl(request, model.getId()));
                }
                catch (Exception e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            } else {
                reqPara = params.getValue("model");
                if (reqPara != null && (typePara = params.getValue("type")) != null) {
                    this.deployModelDefinition(request, response, wfSession, reqPara, typePara);
                } else {
                    reqPara = params.getValue("modelfile");
                    if (reqPara != null && (typePara = params.getValue("type")) != null) {
                        this.deployModelDefinition(request, response, wfSession, reqPara, typePara);
                    } else {
                        this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
                    }
                }
            }
        }
    }

    private void deployModelDefinition(SlingHttpServletRequest request, SlingHttpServletResponse response, WorkflowSession wfSession, RequestParameter reqPara, RequestParameter typePara) {
        try {
            WorkflowModel model = this.serSvc.deserialize(reqPara.getString(), typePara.getString());
            wfSession.deployModel(model);
            this.sendResourceCreatedResponse((HttpServletResponse)response, this.getUrl(request, model.getId()));
        }
        catch (Exception e) {
            this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
        }
    }

    @Override
    protected List<String> getMetaDataExcludes(RequestParameterMap params) {
        return Collections.EMPTY_LIST;
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }

    protected void bindSerSvc(SerializationService serializationService) {
        this.serSvc = serializationService;
    }

    protected void unbindSerSvc(SerializationService serializationService) {
        if (this.serSvc == serializationService) {
            this.serSvc = null;
        }
    }
}

