/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.commons.JSONWriterUtil;
import com.day.cq.workflow.exec.ParticipantChooser;
import com.day.cq.workflow.exec.ParticipantStepChooser;
import com.day.cq.workflow.servlet.WorkflowConsoleUtil;
import com.day.cq.xss.XSSProtectionService;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticipantChooserListServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -780464494271946961L;
    private final Logger log = LoggerFactory.getLogger(ParticipantChooserListServlet.class);
    private XSSProtectionService xss;
    private ComponentContext context;
    private static final String SCRIPT_ROOT = "/etc/workflow/scripts";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        try {
            writer.array();
            this.writeChooserImpl(writer);
            Node scriptRoot = (Node)request.getResourceResolver().getResource(SCRIPT_ROOT).adaptTo(Node.class);
            this.writeScripts(writer, scriptRoot);
            writer.endArray();
        }
        catch (InvalidSyntaxException e) {
            throw new ServletException("Could not lookup java processes.", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServletException("Could not lookup scripts.", (Throwable)e);
        }
        catch (JSONException e) {
            throw new ServletException("Error", (Throwable)e);
        }
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        this.context = context;
    }

    private void writeScripts(JSONWriter writer, Node scriptRoot) throws RepositoryException, JSONException {
        NodeIterator scripts = scriptRoot.getNodes();
        while (scripts.hasNext()) {
            Node script = scripts.nextNode();
            if (script.isNodeType("nt:folder")) {
                this.writeScripts(writer, script);
                continue;
            }
            try {
                String title = this.getScriptTitle(script);
                String path = this.getScriptPath(script);
                this.writeParticipantChooser(writer, title, path);
            }
            catch (RepositoryException re) {}
        }
    }

    private void writeParticipantChooser(JSONWriter writer, String text, String value) throws JSONException {
        writer.object();
        JSONWriterUtil.write((JSONWriter)writer, (String)"text", (String)text, (JSONWriterUtil.WriteMode)JSONWriterUtil.WriteMode.BOTH, (XSSProtectionService)this.xss);
        writer.key("value").value((Object)value);
        writer.endObject();
    }

    private String getScriptTitle(Node scriptNode) throws ValueFormatException, RepositoryException {
        String title = scriptNode.getPath();
        try {
            Node jcrContent = scriptNode.getNode("jcr:content");
            title = jcrContent.getProperty("jcr:title").getString();
        }
        catch (PathNotFoundException e) {
            this.log.error("trouble resovling jcr:title property form scipt's jcr:content node. Fallback to script path");
        }
        return title;
    }

    private String getScriptPath(Node scriptNode) throws RepositoryException {
        return scriptNode.getPath();
    }

    private void writeChooserImpl(JSONWriter writer) throws JSONException, InvalidSyntaxException {
        List<ServiceReference> refs = WorkflowConsoleUtil.getServiceReferences(this.context, Arrays.asList(ParticipantStepChooser.class.getName(), ParticipantChooser.class.getName()));
        for (ServiceReference ref : refs) {
            Object pid = ref.getProperty("service.pid");
            Object label = ref.getProperty("chooser.label");
            if (!(pid instanceof String)) continue;
            String name = (String)pid;
            if (label != null) {
                name = (String)label;
            }
            this.writeParticipantChooser(writer, name, (String)pid);
        }
    }

    protected void bindXss(XSSProtectionService xSSProtectionService) {
        this.xss = xSSProtectionService;
    }

    protected void unbindXss(XSSProtectionService xSSProtectionService) {
        if (this.xss == xSSProtectionService) {
            this.xss = null;
        }
    }
}

