/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.commons.JSONWriterUtil;
import com.day.cq.workflow.exec.JavaProcess;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.servlet.WorkflowConsoleUtil;
import com.day.cq.xss.XSSProtectionService;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessListServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -780464494271946961L;
    private XSSProtectionService xss;
    private final Logger log = LoggerFactory.getLogger(ProcessListServlet.class);
    private ComponentContext context;
    private static final String SCRIPT_ROOT = "/etc/workflow/scripts";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        boolean list = false;
        String[] selectors = request.getRequestPathInfo().getSelectors();
        if (selectors.length == 1 && selectors[0].equals("list")) {
            list = true;
        }
        JSONWriter w = new JSONWriter((Writer)response.getWriter());
        try {
            List<ServiceReference> refs = WorkflowConsoleUtil.getServiceReferences(this.context, Arrays.asList(WorkflowProcess.class.getName(), JavaProcess.class.getName()));
            if (list) {
                w.array();
            } else {
                w.object().key("processes").array();
            }
            int count = 0;
            for (ServiceReference serviceReferene : refs) {
                Object pid = serviceReferene.getProperty("service.pid");
                Object label = serviceReferene.getProperty("process.label");
                if (!(pid instanceof String)) continue;
                String name = (String)pid;
                if (label != null) {
                    name = (String)label;
                }
                w.object();
                if (list) {
                    JSONWriterUtil.write((JSONWriter)w, (String)"text", (String)name, (JSONWriterUtil.WriteMode)JSONWriterUtil.WriteMode.BOTH, (XSSProtectionService)this.xss);
                    w.key("value").value(pid);
                } else {
                    w.key("rid").value(pid);
                    w.key("label").value((Object)name);
                }
                w.endObject();
                ++count;
            }
            Node scriptRoot = (Node)request.getResourceResolver().getResource(SCRIPT_ROOT).adaptTo(Node.class);
            count = this.getScripts(scriptRoot, count, list, w);
            if (list) {
                w.endArray();
            } else {
                w.endArray().key("results").value((long)count).endObject();
            }
        }
        catch (InvalidSyntaxException e) {
            throw new ServletException("Could not lookup java processes.", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServletException("Could not lookup scripts.", (Throwable)e);
        }
        catch (JSONException e) {
            throw new ServletException("Error", (Throwable)e);
        }
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        this.context = context;
    }

    private int getScripts(Node scriptRoot, int count, boolean list, JSONWriter w) throws RepositoryException, JSONException {
        NodeIterator scripts = scriptRoot.getNodes();
        while (scripts.hasNext()) {
            Node script = scripts.nextNode();
            if (script.isNodeType("nt:folder")) {
                count = this.getScripts(script, count, list, w);
                continue;
            }
            try {
                w.object();
                String title = this.getScriptTitle(script);
                String path = this.getScriptPath(script);
                if (list) {
                    JSONWriterUtil.write((JSONWriter)w, (String)"text", (String)title, (JSONWriterUtil.WriteMode)JSONWriterUtil.WriteMode.BOTH, (XSSProtectionService)this.xss);
                    w.key("value").value((Object)path);
                } else {
                    w.key("rid").value((Object)path);
                    w.key("label").value((Object)title);
                }
                w.endObject();
                ++count;
            }
            catch (RepositoryException re) {}
        }
        return count;
    }

    private String getScriptTitle(Node scriptNode) throws ValueFormatException, RepositoryException {
        String title = scriptNode.getPath();
        try {
            Node jcrContent = scriptNode.getNode("jcr:content");
            title = jcrContent.getProperty("jcr:title").getString();
        }
        catch (PathNotFoundException e) {
            this.log.error("trouble resovling jcr:title property form scipt's jcr:content node. Fallback to script path");
        }
        return title;
    }

    private String getScriptPath(Node scriptNode) throws RepositoryException {
        return scriptNode.getPath();
    }

    protected void bindXss(XSSProtectionService xSSProtectionService) {
        this.xss = xSSProtectionService;
    }

    protected void unbindXss(XSSProtectionService xSSProtectionService) {
        if (this.xss == xSSProtectionService) {
            this.xss = null;
        }
    }
}

