/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.servlet.ServletBase;
import com.day.cq.workflow.util.WorkflowUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.event.JobStatusProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestarterServlet
extends ServletBase {
    private static final Logger log = LoggerFactory.getLogger(RestarterServlet.class);
    private static final long serialVersionUID = 2171661388034822790L;
    private static final String PATH_PARAM_NAME = "path";
    private WorkflowService workflowService;
    private JobStatusProvider jobStatusProvider;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block6: {
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            RequestParameterMap params = request.getRequestParameterMap();
            WorkflowSession wfSession = this.workflowService.getWorkflowSession(session);
            RequestParameter path = params.getValue(PATH_PARAM_NAME);
            if (path != null) {
                try {
                    Workflow workflow = wfSession.getWorkflow(path.toString());
                    Collection jobs = WorkflowUtil.getEvents((JobStatusProvider)this.jobStatusProvider, (WorkflowSession)wfSession);
                    if (WorkflowUtil.isStale((Workflow)workflow, (Collection)jobs)) {
                        wfSession.restartWorkflow(workflow);
                        this.sendResponse((HttpServletResponse)response, 200, "Workflow " + workflow.getId() + " restarted");
                        break block6;
                    }
                    log.debug("No need to restart workflow: " + workflow.getId());
                }
                catch (IllegalStateException e) {
                    this.sendResponse((HttpServletResponse)response, 409, e.getMessage());
                }
                catch (Exception e) {
                    this.sendResponse((HttpServletResponse)response, 500, e.getMessage());
                }
            } else {
                this.sendResponse((HttpServletResponse)response, 400, "Invalid parameters");
            }
        }
    }

    @Override
    protected List<String> getMetaDataExcludes(RequestParameterMap params) {
        return Collections.EMPTY_LIST;
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }

    protected void bindJobStatusProvider(JobStatusProvider jobStatusProvider) {
        this.jobStatusProvider = jobStatusProvider;
    }

    protected void unbindJobStatusProvider(JobStatusProvider jobStatusProvider) {
        if (this.jobStatusProvider == jobStatusProvider) {
            this.jobStatusProvider = null;
        }
    }
}

