/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.xss.ProtectionContext;
import com.day.cq.xss.XSSProtectionException;
import com.day.cq.xss.XSSProtectionService;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowSummaryServlet
extends SlingSafeMethodsServlet {
    protected static final String FORM_START_RESOURCE_TYPE = "foundation/components/form/start";
    protected static final String FORM_END_RESOURCE_TYPE = "foundation/components/form/end";
    private XSSProtectionService xss;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block6: {
            response.setContentType(request.getResponseContentType());
            response.setCharacterEncoding("UTF-8");
            try {
                JSONWriter w = new JSONWriter((Writer)response.getWriter());
                Resource resource = request.getResource();
                ResourceResolver resolver = request.getResourceResolver();
                ValueMap values = (ValueMap)resource.adaptTo(ValueMap.class);
                ValueMap parentValues = (ValueMap)ResourceUtil.getParent((Resource)resource).adaptTo(ValueMap.class);
                if (parentValues.containsKey((Object)"formPath")) {
                    Resource form = resolver.getResource(ResourceUtil.getParent((String)((String)parentValues.get((Object)"formPath"))));
                    String formStartName = ResourceUtil.getName((String)((String)parentValues.get((Object)"formPath")));
                    Iterator children = resolver.listChildren(form);
                    while (children.hasNext()) {
                        Resource child = (Resource)children.next();
                        if (!ResourceUtil.isA((Resource)child, (String)FORM_START_RESOURCE_TYPE) || !ResourceUtil.getName((Resource)child).equals(formStartName)) continue;
                        String description = this.getFormDescription(values, children);
                        w.object();
                        w.key("description").value((Object)description.toString());
                        w.endObject();
                        break block6;
                    }
                    break block6;
                }
                if (values.containsKey((Object)"jcr:description")) {
                    w.object();
                    w.key("description").value(values.get((Object)"jcr:description"));
                    w.endObject();
                } else {
                    w.object();
                    w.key("exception").value((Object)("no .wfsummary.json renderer provided for resource " + request.getResource().getPath()));
                    w.endObject();
                }
            }
            catch (JSONException ex) {
                throw new ServletException("JSONException in doGet", (Throwable)ex);
            }
        }
    }

    private String getFormDescription(ValueMap values, Iterator<Resource> children) {
        StringBuffer description = new StringBuffer();
        int count = 0;
        while (children.hasNext()) {
            Resource child = children.next();
            ValueMap fieldValues = (ValueMap)child.adaptTo(ValueMap.class);
            if (ResourceUtil.isA((Resource)child, (String)FORM_END_RESOURCE_TYPE) || count >= 3) break;
            if (!fieldValues.containsKey((Object)"name")) continue;
            if (count > 0 && count < 3) {
                description.append("<br>");
            }
            description.append(fieldValues.get((Object)"name"));
            description.append(": ");
            String value = (String)values.get(fieldValues.get((Object)"name"));
            if (this.xss != null) {
                try {
                    value = this.xss.protectForContext(ProtectionContext.PLAIN_HTML_CONTENT, (String)values.get(fieldValues.get((Object)"name")));
                }
                catch (XSSProtectionException e) {
                    // empty catch block
                }
            }
            description.append(value);
            ++count;
        }
        return description.toString();
    }

    protected void bindXss(XSSProtectionService xSSProtectionService) {
        this.xss = xSSProtectionService;
    }

    protected void unbindXss(XSSProtectionService xSSProtectionService) {
        if (this.xss == xSSProtectionService) {
            this.xss = null;
        }
    }
}

